/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.generator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.token.generator.RefreshTokenGenerator;
import io.micronaut.security.token.jwt.generator.RefreshTokenConfiguration;
import io.micronaut.security.token.validator.RefreshTokenValidator;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(beans={RefreshTokenConfiguration.class})
public class SignedRefreshTokenGenerator
implements RefreshTokenGenerator,
RefreshTokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SignedRefreshTokenGenerator.class);
    private final JWSAlgorithm algorithm;
    private final JWSVerifier verifier;
    private final JWSSigner signer;

    public SignedRefreshTokenGenerator(RefreshTokenConfiguration config) {
        byte[] secret = config.isBase64() ? Base64.getDecoder().decode(config.getSecret()) : config.getSecret().getBytes(StandardCharsets.UTF_8);
        this.algorithm = config.getJwsAlgorithm();
        try {
            this.signer = new MACSigner(secret);
        }
        catch (JOSEException e) {
            throw new ConfigurationException("unable to create a signer", (Throwable)e);
        }
        try {
            this.verifier = new MACVerifier(secret);
        }
        catch (JOSEException e) {
            throw new ConfigurationException("unable to create a verifier", (Throwable)e);
        }
    }

    @NonNull
    public String createKey(@NonNull UserDetails userDetails) {
        return UUID.randomUUID().toString();
    }

    @NonNull
    public Optional<String> generate(@NonNull UserDetails userDetails, @NonNull String token) {
        try {
            JWSObject jwsObject = new JWSObject(new JWSHeader(this.algorithm), new Payload(token));
            jwsObject.sign(this.signer);
            return Optional.of(jwsObject.serialize());
        }
        catch (JOSEException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("JOSEException signing a JWS Object");
            }
            return Optional.empty();
        }
    }

    @NonNull
    public Optional<String> validate(@NonNull String refreshToken) {
        block5: {
            JWSObject jwsObject = null;
            try {
                jwsObject = JWSObject.parse((String)refreshToken);
                if (jwsObject.verify(this.verifier)) {
                    return Optional.of(jwsObject.getPayload().toString());
                }
            }
            catch (ParseException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Parse exception parsing refresh token {} into JWS Object", (Object)refreshToken);
                }
                return Optional.empty();
            }
            catch (JOSEException e) {
                if (!LOG.isWarnEnabled()) break block5;
                LOG.warn("JOSEException parsing refresh token {} into JWS Object", (Object)refreshToken);
            }
        }
        return Optional.empty();
    }
}

