/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.render;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.Nullable;

@Introspected
public class AccessRefreshToken {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String refreshToken;
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="expires_in")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer expiresIn;

    public AccessRefreshToken() {
    }

    public AccessRefreshToken(String accessToken, @Nullable String refreshToken, String tokenType) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
    }

    @Creator
    public AccessRefreshToken(String accessToken, @Nullable String refreshToken, String tokenType, @Nullable Integer expiresIn) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }
}

