/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.security.token.jwt.validator.JwtAuthenticationFactory;
import jakarta.inject.Singleton;
import java.text.ParseException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultJwtAuthenticationFactory
implements JwtAuthenticationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJwtAuthenticationFactory.class);
    private final TokenConfiguration tokenConfiguration;
    private final RolesFinder rolesFinder;

    public DefaultJwtAuthenticationFactory(TokenConfiguration tokenConfiguration, RolesFinder rolesFinder) {
        this.tokenConfiguration = tokenConfiguration;
        this.rolesFinder = rolesFinder;
    }

    @Override
    public Optional<Authentication> createAuthentication(JWT token) {
        try {
            JWTClaimsSet claimSet = token.getJWTClaimsSet();
            if (claimSet == null) {
                return Optional.empty();
            }
            Map attributes = claimSet.getClaims();
            return this.usernameForClaims(claimSet).map(username -> Authentication.build((String)username, (Collection)this.rolesFinder.resolveRoles(attributes), (Map)attributes));
        }
        catch (ParseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("ParseException creating authentication", (Throwable)e);
            }
            return Optional.empty();
        }
    }

    protected Optional<String> usernameForClaims(JWTClaimsSet claimSet) throws ParseException {
        String username = claimSet.getStringClaim(this.tokenConfiguration.getNameKey());
        if (username == null) {
            return Optional.ofNullable(claimSet.getSubject());
        }
        return Optional.of(username);
    }
}

