/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.bearer;

import io.micronaut.context.annotation.Requires;
import io.micronaut.security.token.jwt.bearer.BearerTokenConfiguration;
import io.micronaut.security.token.jwt.cookie.JwtCookieTokenReader;
import io.micronaut.security.token.reader.HttpHeaderTokenReader;
import io.micronaut.security.token.reader.TokenReader;
import jakarta.inject.Singleton;

@Requires(property="micronaut.security.token.jwt.bearer.enabled", notEquals="false")
@Singleton
public class BearerTokenReader
extends HttpHeaderTokenReader
implements TokenReader {
    public static final Integer ORDER = JwtCookieTokenReader.ORDER - 100;
    protected final BearerTokenConfiguration bearerTokenConfiguration;

    public BearerTokenReader(BearerTokenConfiguration bearerTokenConfiguration) {
        this.bearerTokenConfiguration = bearerTokenConfiguration;
    }

    protected String getHeaderName() {
        return this.bearerTokenConfiguration.getHeaderName();
    }

    protected String getPrefix() {
        return this.bearerTokenConfiguration.getPrefix();
    }

    public int getOrder() {
        return ORDER;
    }
}

