/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.ec;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.token.jwt.signature.SignatureGeneratorConfiguration;
import io.micronaut.security.token.jwt.signature.ec.ECSignature;
import io.micronaut.security.token.jwt.signature.ec.ECSignatureGeneratorConfiguration;
import java.security.interfaces.ECPrivateKey;

public class ECSignatureGenerator
extends ECSignature
implements SignatureGeneratorConfiguration {
    private final ECPrivateKey privateKey;
    @Nullable
    private final String kidId;

    public ECSignatureGenerator(ECSignatureGeneratorConfiguration config) {
        super(config);
        this.privateKey = config.getPrivateKey();
        this.kidId = config.getKid().orElse(null);
    }

    @Override
    public SignedJWT sign(JWTClaimsSet claims) throws JOSEException {
        return this.signWithPrivateKey(claims, this.privateKey, this.kidId);
    }

    @Deprecated
    protected SignedJWT signWithPrivateKey(JWTClaimsSet claims, @NonNull ECPrivateKey privateKey) throws JOSEException {
        return this.signWithPrivateKey(claims, privateKey, null);
    }

    protected SignedJWT signWithPrivateKey(JWTClaimsSet claims, @NonNull ECPrivateKey privateKey, @Nullable String kid) throws JOSEException {
        ECDSASigner signer = new ECDSASigner(privateKey);
        SignedJWT signedJWT = new SignedJWT(this.header(kid), claims);
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }

    @NonNull
    private JWSHeader header(@Nullable String keyId) {
        JWSHeader.Builder builder = new JWSHeader.Builder(this.algorithm);
        if (keyId != null) {
            builder = builder.keyID(keyId);
        }
        return builder.build();
    }
}

