/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.nimbus;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.jwt.nimbus.AbstractJsonWebTokenValidator;
import io.micronaut.security.token.jwt.signature.ReactiveSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JsonWebTokenParser;
import io.micronaut.security.token.jwt.validator.JwtAuthenticationFactory;
import io.micronaut.security.token.jwt.validator.ReactiveJsonWebTokenSignatureValidator;
import io.micronaut.security.token.jwt.validator.ReactiveJsonWebTokenValidator;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Singleton
class NimbusReactiveJsonWebTokenValidator<R>
extends AbstractJsonWebTokenValidator<R>
implements ReactiveJsonWebTokenValidator<JWT, R> {
    private final JwtAuthenticationFactory jwtAuthenticationFactory;
    private final JsonWebTokenParser<JWT> jsonWebTokenParser;
    private final ReactiveJsonWebTokenSignatureValidator<SignedJWT> signatureValidator;

    NimbusReactiveJsonWebTokenValidator(List<GenericJwtClaimsValidator<R>> claimsValidators, List<SignatureConfiguration> imperativeSignatureConfigurations, List<ReactiveSignatureConfiguration<SignedJWT>> reactiveSignatureConfigurations, JsonWebTokenParser<JWT> jsonWebTokenParser, ReactiveJsonWebTokenSignatureValidator<SignedJWT> signatureValidator, JwtAuthenticationFactory jwtAuthenticationFactory) {
        super(claimsValidators, imperativeSignatureConfigurations, reactiveSignatureConfigurations);
        this.jsonWebTokenParser = jsonWebTokenParser;
        this.signatureValidator = signatureValidator;
        this.jwtAuthenticationFactory = jwtAuthenticationFactory;
    }

    @SingleResult
    public Publisher<Authentication> validateToken(String token, R request) {
        return Mono.from(this.validate(token, request)).map(this.jwtAuthenticationFactory::createAuthentication).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    @NonNull
    public Publisher<JWT> validate(@NonNull String token, @Nullable R request) {
        Optional<JWT> jwtOptional = this.jsonWebTokenParser.parse(token);
        if (jwtOptional.isEmpty()) {
            return Mono.empty();
        }
        JWT jwt = jwtOptional.get();
        return this.validateSignature(jwt).filter(valid -> valid != false && this.validateClaims(jwt, request)).map(valid -> jwt);
    }

    private Mono<Boolean> validateSignature(JWT jwt) {
        if (jwt instanceof PlainJWT) {
            PlainJWT plainJWT = (PlainJWT)jwt;
            return Mono.just((Object)this.validateSignature(plainJWT));
        }
        if (jwt instanceof SignedJWT) {
            SignedJWT signedJWT = (SignedJWT)jwt;
            return Mono.from(this.signatureValidator.validateSignature(signedJWT));
        }
        return Mono.just((Object)false);
    }
}

