/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import com.nimbusds.jose.jwk.JWKSet;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.security.token.jwt.signature.jwks.CacheableJwkSetFetcher;
import io.micronaut.security.token.jwt.signature.jwks.DefaultJwkSetFetcher;
import io.micronaut.security.token.jwt.signature.jwks.JwksClient;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfiguration;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Requires(missingBeans={CacheableJwkSetFetcher.class})
@Internal
@Primary
@Singleton
@Deprecated(forRemoval=true, since="4.11.0")
final class ReactorCacheJwkSetFetcher
extends DefaultJwkSetFetcher {
    private final Map<CacheKey, Mono<JwksCacheEntry>> cache = new ConcurrentHashMap<CacheKey, Mono<JwksCacheEntry>>();
    private final Map<String, JwksSignatureConfiguration> jwksSignatureConfigurations;

    ReactorCacheJwkSetFetcher(JwksClient jwksClient, Map<String, JwksSignatureConfiguration> jwksSignatureConfigurations) {
        super(jwksClient);
        this.jwksSignatureConfigurations = jwksSignatureConfigurations;
    }

    @Override
    @NonNull
    @SingleResult
    public Publisher<JWKSet> fetch(@Nullable String providerName, @Nullable String url) {
        CacheKey k = new CacheKey(providerName, url);
        return this.cache.computeIfAbsent(k, this::jwksCacheEntry).map(JwksCacheEntry::jwkSet);
    }

    private Mono<JwksCacheEntry> jwksCacheEntry(CacheKey cacheKey) {
        return Mono.from(super.fetch(cacheKey.providerName, cacheKey.url())).defaultIfEmpty((Object)new JWKSet()).map(jwksSet -> this.instantiateCacheEntry(cacheKey, (JWKSet)jwksSet)).cacheInvalidateIf(JwksCacheEntry::isExpired);
    }

    private JwksCacheEntry instantiateCacheEntry(CacheKey cacheKey, JWKSet jwkSet) {
        return new JwksCacheEntry(jwkSet, Instant.now().plusSeconds(this.jwksSignatureConfigurations.get(cacheKey.providerName) != null ? (long)this.jwksSignatureConfigurations.get(cacheKey.providerName).getCacheExpiration().intValue() : 60L));
    }

    private record CacheKey(String providerName, String url) {
    }

    private record JwksCacheEntry(JWKSet jwkSet, Instant cacheExpiryAt) {
        private boolean isExpired() {
            return this.jwkSet.isEmpty() || this.cacheExpiryAt != null && Instant.now().isAfter(this.cacheExpiryAt);
        }
    }
}

