/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import com.nimbusds.jwt.JWTClaimsSet;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.token.Claims;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JWTClaimsSetUtils;
import io.micronaut.security.token.jwt.validator.JwtClaimsValidatorConfiguration;
import jakarta.inject.Singleton;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="micronaut.security.token.jwt.claims-validators.audience")
public class AudienceJwtClaimsValidator<T>
implements GenericJwtClaimsValidator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AudienceJwtClaimsValidator.class);
    @Nullable
    private final String expectedAudience;

    public AudienceJwtClaimsValidator(JwtClaimsValidatorConfiguration jwtClaimsValidatorConfiguration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing AudienceJwtClaimsValidator with audience: {}", (Object)jwtClaimsValidatorConfiguration.getAudience());
        }
        this.expectedAudience = jwtClaimsValidatorConfiguration.getAudience();
    }

    protected boolean validate(JWTClaimsSet claimsSet) {
        if (this.expectedAudience == null) {
            return true;
        }
        List audience = claimsSet.getAudience();
        if (audience.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Expected JWT audience claim {} but audience list is not specified", (Object)this.expectedAudience);
            }
            return false;
        }
        if (!audience.contains(this.expectedAudience)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Expected JWT audience claim to include '{}', but audience list ({}) did not.", (Object)this.expectedAudience, (Object)String.join((CharSequence)",", audience));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(@NonNull Claims claims, @Nullable T request) {
        return this.validate(JWTClaimsSetUtils.jwtClaimsSetFromClaims(claims));
    }
}

