/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.nimbus;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.security.token.jwt.generator.claims.JwtClaimsSetAdapter;
import io.micronaut.security.token.jwt.signature.ReactiveSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JwtClaimsValidator;
import java.text.ParseException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractJsonWebTokenValidator<R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJsonWebTokenValidator.class);
    private final boolean noSignatures;
    private List<? extends JwtClaimsValidator<R>> claimsValidators;

    AbstractJsonWebTokenValidator(List<GenericJwtClaimsValidator<R>> claimsValidators, List<SignatureConfiguration> imperativeSignatureConfigurations, List<ReactiveSignatureConfiguration<SignedJWT>> reactiveSignatureConfigurations) {
        this.claimsValidators = claimsValidators;
        this.noSignatures = imperativeSignatureConfigurations.isEmpty() && reactiveSignatureConfigurations.isEmpty();
    }

    protected boolean validateSignature(PlainJWT plainJWT) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating plain JWT");
        }
        if (this.noSignatures) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JWT is not signed and no signature configurations -> verified");
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("A non-signed JWT cannot be accepted as signature configurations have been defined");
        }
        return false;
    }

    protected boolean validateClaims(JWT jwt, R request) {
        block4: {
            if (this.claimsValidators.isEmpty()) {
                return true;
            }
            try {
                JwtClaimsSetAdapter claims = new JwtClaimsSetAdapter(jwt.getJWTClaimsSet());
                if (this.claimsValidators.stream().allMatch(validator -> validator.validate(claims, request))) {
                    return true;
                }
            }
            catch (ParseException e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error("Failed to retrieve the claims set", (Throwable)e);
            }
        }
        return false;
    }
}

