/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.nimbus;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.security.token.jwt.signature.ReactiveSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.jwks.JwkSetFetcher;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@EachBean(value=JwksSignatureConfiguration.class)
public class ReactiveJwksSignature
implements ReactiveSignatureConfiguration<SignedJWT> {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveJwksSignature.class);
    private final JwkValidator jwkValidator;
    private final JwksSignatureConfiguration jwksSignatureConfiguration;
    private final JwkSetFetcher<JWKSet> jwkSetFetcher;

    public ReactiveJwksSignature(JwksSignatureConfiguration jwksSignatureConfiguration, JwkValidator jwkValidator, JwkSetFetcher<JWKSet> jwkSetFetcher) {
        this.jwksSignatureConfiguration = jwksSignatureConfiguration;
        this.jwkValidator = jwkValidator;
        this.jwkSetFetcher = jwkSetFetcher;
    }

    @Override
    @SingleResult
    public Publisher<Boolean> verify(SignedJWT jwt) {
        return Mono.from(this.jwkSetFetcher.fetch(this.jwksSignatureConfiguration.getName(), this.jwksSignatureConfiguration.getUrl())).map(jwkSet -> {
            try {
                boolean result = JwksSignatureUtils.verify(jwt, jwkSet, this.jwkValidator);
                if (LOG.isDebugEnabled()) {
                    if (result) {
                        LOG.debug("JWT Signature verified: {}", (Object)jwt.getParsedString());
                    } else {
                        LOG.debug("JWT Signature not verified: {}", (Object)jwt.getParsedString());
                        if (!JwksSignatureUtils.supports(jwt.getHeader().getAlgorithm(), jwkSet)) {
                            LOG.debug("JWT Signature algorithm {} not supported by JWK Set. {} ", (Object)jwt.getHeader().getAlgorithm(), (Object)JwksSignatureUtils.supportedAlgorithmsMessage(jwkSet));
                        }
                    }
                }
                return result;
            }
            catch (JOSEException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error verifying JWT signature", (Throwable)e);
                }
                return false;
            }
        });
    }
}

