/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import io.micronaut.cache.CacheConfiguration;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Optional;

@Internal
final class JwksCacheConfigurationExistsCondition
implements Condition {
    JwksCacheConfigurationExistsCondition() {
    }

    public boolean matches(ConditionContext context) {
        try {
            Optional beanOptional = context.findBean(CacheConfiguration.class, Qualifiers.byName((String)"jwks"));
            if (beanOptional.isEmpty()) {
                context.fail("No bean of type io.micronaut.cache.CacheConfiguration and name qualifier jwks found");
            }
            return beanOptional.isPresent();
        }
        catch (ConfigurationException e) {
            context.fail("No bean of type io.micronaut.cache.CacheConfiguration and name qualifier jwks found");
            return false;
        }
    }
}

