/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.token.jwt.generator.claims.JwtClaims;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requirements(value={@Requires(property="micronaut.security.authentication", value="idtoken"), @Requires(property="micronaut.security.token.jwt.claims-validators.openid-idtoken", notEquals="false")})
@Singleton
public class IdTokenClaimsValidator
implements GenericJwtClaimsValidator {
    private static final Logger LOG = LoggerFactory.getLogger(IdTokenClaimsValidator.class);
    private static final String AUTHORIZED_PARTY = "azp";
    private final Collection<OauthClientConfiguration> oauthClientConfigurations;

    public IdTokenClaimsValidator(Collection<OauthClientConfiguration> oauthClientConfigurations) {
        this.oauthClientConfigurations = oauthClientConfigurations;
    }

    public boolean validate(JwtClaims claims) {
        return this.validate(claims, null);
    }

    public boolean validate(@NonNull JwtClaims claims, @Nullable HttpRequest<?> request) {
        Object obj = claims.get("iss");
        if (obj == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} claim not present", (Object)"iss");
            }
            return false;
        }
        String iss = obj.toString();
        obj = claims.get("aud");
        if (obj == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} claim not present", (Object)"aud");
            }
            return false;
        }
        ArrayList<String> audiences = new ArrayList<String>();
        if (obj instanceof List) {
            for (Object listObj : (List)obj) {
                audiences.add(listObj.toString());
            }
        } else {
            audiences.add(obj.toString());
        }
        for (OauthClientConfiguration oauthClientConfiguration : this.oauthClientConfigurations) {
            Optional<URL> issuerOptional;
            OpenIdClientConfiguration openIdClientConfiguration;
            Optional<OpenIdClientConfiguration> openIdClientConfigurationOptional = oauthClientConfiguration.getOpenid();
            if (!openIdClientConfigurationOptional.isPresent() || !(openIdClientConfiguration = openIdClientConfigurationOptional.get()).getIssuer().isPresent() || !(issuerOptional = openIdClientConfiguration.getIssuer()).isPresent()) continue;
            String issuer = issuerOptional.get().toString();
            String clientId = oauthClientConfiguration.getClientId();
            if (!issuer.equalsIgnoreCase(iss) && (!audiences.contains(clientId) || !this.validateAzp(clientId, claims, audiences))) continue;
            return true;
        }
        return false;
    }

    private boolean validateAzp(@NonNull String clientId, @NonNull JwtClaims claims, @NonNull List<String> audiences) {
        if (audiences.size() < 2) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} claim is not required for single audiences", (Object)AUTHORIZED_PARTY);
            }
            return true;
        }
        Object obj = claims.get(AUTHORIZED_PARTY);
        if (obj == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} claim not present", (Object)AUTHORIZED_PARTY);
            }
            return false;
        }
        String azp = obj.toString();
        boolean result = azp.equalsIgnoreCase(clientId);
        if (!result && LOG.isTraceEnabled()) {
            LOG.trace("{} claim does not match client id {}", (Object)AUTHORIZED_PARTY, (Object)clientId);
        }
        return result;
    }
}

