/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.response;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.oauth2.endpoint.authorization.response.AbstractAuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.OpenIdAuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateSerDes;
import io.micronaut.security.oauth2.endpoint.nonce.persistence.NoncePersistence;
import java.util.Map;
import java.util.Optional;

@Prototype
public class DefaultOpenIdAuthorizationResponse
extends AbstractAuthorizationResponse
implements OpenIdAuthorizationResponse {
    private final NoncePersistence noncePersistence;

    public DefaultOpenIdAuthorizationResponse(@Parameter HttpRequest<Map<String, Object>> request, StateSerDes stateSerDes, @Nullable NoncePersistence noncePersistence) {
        super(request, stateSerDes);
        this.noncePersistence = noncePersistence;
    }

    @Override
    @Nullable
    public String getNonce() {
        return Optional.ofNullable(this.noncePersistence).flatMap(np -> np.retrieveNonce(this.getCallbackRequest())).orElse(null);
    }
}

