/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request.password;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.password.OauthPasswordAuthenticationProvider;
import io.micronaut.security.oauth2.endpoint.token.request.password.OpenIdPasswordAuthenticationProvider;
import io.micronaut.security.oauth2.endpoint.token.request.password.PasswordGrantCondition;
import io.micronaut.security.oauth2.endpoint.token.response.DefaultOpenIdUserDetailsMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OauthUserDetailsMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdUserDetailsMapper;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdTokenResponseValidator;

@Factory
@Internal
class PasswordGrantFactory {
    PasswordGrantFactory() {
    }

    @EachBean(value=OauthClientConfiguration.class)
    @Requires(condition=PasswordGrantCondition.class)
    AuthenticationProvider passwordGrantProvider(@Parameter OauthClientConfiguration clientConfiguration, @Parameter @Nullable OauthUserDetailsMapper userDetailsMapper, @Parameter @Nullable OpenIdUserDetailsMapper openIdUserDetailsMapper, @Parameter @Nullable OpenIdProviderMetadata openIdProviderMetadata, TokenEndpointClient tokenEndpointClient, @Nullable DefaultOpenIdUserDetailsMapper defaultOpenIdUserDetailsMapper, @Nullable OpenIdTokenResponseValidator tokenResponseValidator) {
        if (clientConfiguration.getToken().isPresent()) {
            return new OauthPasswordAuthenticationProvider(tokenEndpointClient, clientConfiguration, userDetailsMapper);
        }
        if (openIdUserDetailsMapper == null) {
            openIdUserDetailsMapper = defaultOpenIdUserDetailsMapper;
        }
        return new OpenIdPasswordAuthenticationProvider(clientConfiguration, openIdProviderMetadata, tokenEndpointClient, openIdUserDetailsMapper, tokenResponseValidator);
    }
}

