/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.endsession.request;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.uri.UriTemplate;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.endsession.request.EndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;

public abstract class AbstractEndSessionRequest
implements EndSessionEndpoint {
    private static final String PARAMETERS_KEY = "parameters";
    protected final EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder;
    protected final OauthClientConfiguration clientConfiguration;
    protected final Supplier<OpenIdProviderMetadata> providerMetadataSupplier;

    public AbstractEndSessionRequest(EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder, OauthClientConfiguration clientConfiguration, Supplier<OpenIdProviderMetadata> providerMetadata) {
        this.endSessionCallbackUrlBuilder = endSessionCallbackUrlBuilder;
        this.clientConfiguration = clientConfiguration;
        this.providerMetadataSupplier = providerMetadata;
    }

    @Override
    @Nullable
    public String getUrl(HttpRequest<?> originating, Authentication authentication) {
        return this.getTemplate().expand(this.getParameters(originating, authentication));
    }

    private Map<String, Object> getParameters(HttpRequest<?> originating, Authentication authentication) {
        return Collections.singletonMap(PARAMETERS_KEY, this.getArguments(originating, authentication));
    }

    private UriTemplate getTemplate() {
        return UriTemplate.of((String)this.getUrl()).nest((CharSequence)"{?parameters*}");
    }

    protected abstract String getUrl();

    protected abstract Map<String, Object> getArguments(HttpRequest<?> var1, Authentication var2);

    protected String getRedirectUri(HttpRequest<?> originating) {
        return this.endSessionCallbackUrlBuilder.build(originating).toString();
    }
}

