/*
 * Copyright 2017-2022 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.security.oauth2.endpoint.authorization.pkce;

import io.micronaut.core.annotation.NonNull;

/**
 * Proof Key for Code Exchange Challenge.
 * @see <a href="https://www.rfc-editor.org/rfc/rfc7636">RFC 7636</a>
 */
public interface PkceChallenge {
    /**
     * @return A challenge derived from the code verifier that is sent in the authorization request, to be verified against later.
     */
    @NonNull
    String getCodeChallenge();

    /**
     * @see <a href="https://www.rfc-editor.org/rfc/rfc7636">RFC 7636</a>
     * @return A method that was used to derive code challenge.
     */
    @NonNull
    String getCodeChallengeMethod();
}
