/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.grants;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.security.oauth2.grants.AbstractClientSecureGrant;
import io.micronaut.security.oauth2.grants.AsMap;
import io.micronaut.security.oauth2.grants.GrantType;
import io.micronaut.security.oauth2.grants.SecureGrant;
import java.util.Map;
import javax.validation.constraints.NotBlank;

@Introspected
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ClientCredentialsGrant
extends AbstractClientSecureGrant
implements SecureGrant,
AsMap {
    public static final String KEY_SCOPES = "scope";
    @NonNull
    @NotBlank
    private String grantType = GrantType.CLIENT_CREDENTIALS.toString();
    @Nullable
    private String scope;

    @Override
    @NonNull
    public String getGrantType() {
        return this.grantType;
    }

    @Override
    public void setGrantType(@NonNull String grantType) {
        this.grantType = grantType;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public void setScope(@Nullable String scope) {
        this.scope = scope;
    }

    @Override
    @NonNull
    public Map<String, String> toMap() {
        Map<String, String> m = super.toMap();
        if (StringUtils.isNotEmpty((CharSequence)this.scope)) {
            m.put(KEY_SCOPES, this.scope);
        }
        return m;
    }
}

