/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.pkce;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.CodeVerifierGenerator;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.Pkce;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceGenerator;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.Sha256Condition;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;

@Named(value="S256")
@Singleton
@Requires(condition=Sha256Condition.class)
public class S256PkceGenerator
implements PkceGenerator {
    public static final Integer ORDER = 0;
    public static final String CODE_CHALLENGE_METHOD_S256 = "S256";
    private final CodeVerifierGenerator codeVerifierGenerator;

    public S256PkceGenerator(CodeVerifierGenerator codeVerifierGenerator) {
        this.codeVerifierGenerator = codeVerifierGenerator;
    }

    @NonNull
    public String getName() {
        return CODE_CHALLENGE_METHOD_S256;
    }

    public int getOrder() {
        return ORDER;
    }

    @Override
    public boolean supportsAny(@NonNull List<String> codeChallengeMethods) {
        return codeChallengeMethods.stream().anyMatch(m -> m.equalsIgnoreCase(CODE_CHALLENGE_METHOD_S256));
    }

    @Override
    @NonNull
    public Pkce generate() {
        String codeVerifier = this.codeVerifierGenerator.generate();
        return new Pkce(CODE_CHALLENGE_METHOD_S256, S256PkceGenerator.hash(codeVerifier), codeVerifier);
    }

    @NonNull
    public static String hash(@NonNull String value) {
        try {
            MessageDigest sha256Digester = MessageDigest.getInstance("SHA-256");
            sha256Digester.update(value.getBytes(StandardCharsets.ISO_8859_1));
            byte[] digestBytes = sha256Digester.digest();
            return Base64.getUrlEncoder().withoutPadding().encodeToString(digestBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfigurationException("SHA-256 is not supported on this device!. This should bean should not have been loaded");
        }
    }
}

