/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.nonce.persistence.session;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.oauth2.endpoint.nonce.persistence.NoncePersistence;
import io.micronaut.session.Session;
import io.micronaut.session.SessionStore;
import io.micronaut.session.http.SessionForRequest;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requirements(value={@Requires(beans={SessionStore.class}), @Requires(property="micronaut.security.oauth2.openid.nonce.persistence", value="session")})
@Singleton
public class SessionNoncePersistence
implements NoncePersistence {
    private static final String SESSION_KEY = "openIdNonce";
    private final SessionStore<Session> sessionStore;

    public SessionNoncePersistence(SessionStore<Session> sessionStore) {
        this.sessionStore = sessionStore;
    }

    @Override
    public Optional<String> retrieveNonce(HttpRequest<?> request) {
        return SessionForRequest.find(request).flatMap(session -> {
            Optional state = session.get((CharSequence)SESSION_KEY, String.class);
            if (state.isPresent()) {
                session.remove((CharSequence)SESSION_KEY);
            }
            return state;
        });
    }

    @Override
    public void persistNonce(HttpRequest<?> request, MutableHttpResponse response, String state) {
        Session session = SessionForRequest.find(request).orElseGet(() -> SessionForRequest.create(this.sessionStore, (HttpRequest)request));
        session.put((CharSequence)SESSION_KEY, (Object)state);
    }
}

