/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.clientcredentials.propagation;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsEnabled;
import io.micronaut.security.oauth2.client.clientcredentials.propagation.ClientCredentialsHeaderPropagatorEnabled;
import io.micronaut.security.oauth2.client.clientcredentials.propagation.ClientCredentialsHeaderTokenPropagatorConfiguration;
import io.micronaut.security.oauth2.client.clientcredentials.propagation.ClientCredentialsTokenPropagator;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import java.util.Optional;

@Internal
@EachBean(value=OauthClientConfiguration.class)
@Requirements(value={@Requires(condition=ClientCredentialsEnabled.class), @Requires(condition=ClientCredentialsHeaderPropagatorEnabled.class)})
public class ClientCredentialsHeaderTokenPropagator
implements ClientCredentialsTokenPropagator {
    public static final String SPACE = " ";
    protected final ClientCredentialsHeaderTokenPropagatorConfiguration configuration;

    public ClientCredentialsHeaderTokenPropagator(ClientCredentialsHeaderTokenPropagatorConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void writeToken(@NonNull MutableHttpRequest<?> request, @NonNull String token) {
        request.header((CharSequence)this.configuration.getHeaderName(), (CharSequence)this.headerValue(token));
    }

    @Override
    public Optional<String> findToken(@NonNull HttpRequest<?> request) {
        HttpHeaders headers = request.getHeaders();
        Optional authorizationHeader = headers.findFirst((CharSequence)this.configuration.getHeaderName());
        return authorizationHeader.flatMap(this::extractTokenFromAuthorization);
    }

    protected String headerValue(String token) {
        StringBuilder sb = this.prefix();
        sb.append(token);
        return sb.toString();
    }

    protected Optional<String> extractTokenFromAuthorization(String authorization) {
        StringBuilder sb = this.prefix();
        String str = sb.toString();
        if (authorization.startsWith(str)) {
            return Optional.of(authorization.substring(str.length()));
        }
        return Optional.empty();
    }

    @NonNull
    private StringBuilder prefix() {
        StringBuilder sb = new StringBuilder();
        String prefix = this.configuration.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            sb.append(prefix);
            if (!prefix.endsWith(SPACE)) {
                sb.append(SPACE);
            }
        }
        return sb;
    }

    public ClientCredentialsHeaderTokenPropagatorConfiguration getConfiguration() {
        return this.configuration;
    }
}

