/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.response;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleMultiValuesMap;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.errors.ErrorCode;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationErrorCode;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationErrorResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.StateAwareAuthorizationCallback;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateSerDes;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Prototype
public class DefaultAuthorizationErrorResponse
extends StateAwareAuthorizationCallback
implements AuthorizationErrorResponse {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthorizationErrorResponse.class);
    private final ConvertibleMultiValues<String> responseData;

    public DefaultAuthorizationErrorResponse(@Parameter HttpRequest<Map<String, Object>> request, StateSerDes stateSerDes) {
        super(stateSerDes);
        this.responseData = request.getBody().map(body -> {
            MutableConvertibleMultiValuesMap map = new MutableConvertibleMultiValuesMap();
            body.forEach((key, value) -> map.add((CharSequence)key, (Object)value.toString()));
            return map;
        }).orElseGet(() -> request.getParameters());
    }

    @NonNull
    public ErrorCode getError() {
        return DefaultAuthorizationErrorResponse.getError(this.responseData);
    }

    @NonNull
    static ErrorCode getError(final ConvertibleMultiValues<String> responseData) {
        String name = (String)responseData.get((CharSequence)"error");
        try {
            if (name != null) {
                return AuthorizationErrorCode.valueOf(name.toUpperCase(Locale.ENGLISH));
            }
        }
        catch (IllegalArgumentException e) {
            LOG.trace("{} not found in enum AuthorizationErrorCode", (Object)name);
        }
        return new ErrorCode(){

            public String getErrorCode() {
                return (String)responseData.get((CharSequence)"error");
            }

            public String getErrorCodeDescription() {
                return (String)responseData.get((CharSequence)"error_description");
            }
        };
    }

    @Nullable
    public String getErrorDescription() {
        return (String)this.responseData.get((CharSequence)"error_description");
    }

    @Override
    @Nullable
    public String getStateValue() {
        return (String)this.responseData.get((CharSequence)"state");
    }

    @Nullable
    public String getErrorUri() {
        return (String)this.responseData.get((CharSequence)"error_uri");
    }
}

