/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.grants;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.oauth2.grants.AsMap;
import io.micronaut.security.oauth2.grants.SecureGrant;
import io.micronaut.security.oauth2.grants.SecureGrantMap;
import java.util.Map;

public abstract class AbstractClientSecureGrant
implements SecureGrant,
AsMap {
    private static final String KEY_GRANT_TYPE = "grant_type";
    protected String clientId;
    protected String clientSecret;

    @NonNull
    public abstract String getGrantType();

    public abstract void setGrantType(@NonNull String var1);

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(@Nullable String clientId) {
        this.clientId = clientId;
    }

    @Override
    public void setClientSecret(@Nullable String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    @NonNull
    public Map<String, String> toMap() {
        SecureGrantMap m = new SecureGrantMap();
        m.put(KEY_GRANT_TYPE, this.getGrantType());
        if (this.clientId != null) {
            m.put("client_id", this.clientId);
        }
        if (this.clientSecret != null) {
            m.put("client_secret", this.clientSecret);
        }
        return m;
    }
}

