/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response.validation;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.response.JWTOpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdTokenResponse;
import io.micronaut.security.oauth2.endpoint.token.response.validation.NonceClaimValidator;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdClaimsValidator;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdTokenResponseValidator;
import io.micronaut.security.token.Claims;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.signature.jwks.JwkSetFetcher;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignature;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfigurationProperties;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JwtValidator;
import java.text.ParseException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="4.8.0", forRemoval=true)
public class DefaultOpenIdTokenResponseValidator
implements OpenIdTokenResponseValidator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOpenIdTokenResponseValidator.class);
    private final Collection<OpenIdClaimsValidator> openIdClaimsValidators;
    private final Collection<GenericJwtClaimsValidator> genericJwtClaimsValidators;
    private final NonceClaimValidator nonceClaimValidator;
    private final JwkValidator jwkValidator;
    private final Map<String, JwksSignature> jwksSignatures = new ConcurrentHashMap<String, JwksSignature>();
    private final JwkSetFetcher<JWKSet> jwkSetFetcher;

    public DefaultOpenIdTokenResponseValidator(Collection<OpenIdClaimsValidator> idTokenValidators, Collection<GenericJwtClaimsValidator> genericJwtClaimsValidators, @Nullable NonceClaimValidator nonceClaimValidator, JwkValidator jwkValidator, JwkSetFetcher<JWKSet> jwkSetFetcher) {
        this.openIdClaimsValidators = idTokenValidators;
        this.genericJwtClaimsValidators = genericJwtClaimsValidators;
        this.nonceClaimValidator = nonceClaimValidator;
        this.jwkValidator = jwkValidator;
        this.jwkSetFetcher = jwkSetFetcher;
    }

    @Override
    public Optional<JWT> validate(OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata openIdProviderMetadata, OpenIdTokenResponse openIdTokenResponse, @Nullable String nonce) {
        Optional<JWT> jwt;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Validating the JWT signature using the JWKS uri [{}]", (Object)openIdProviderMetadata.getJwksUri());
        }
        if ((jwt = this.parseJwtWithValidSignature(openIdProviderMetadata, openIdTokenResponse)).isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("JWT signature validation succeeded. Validating claims...");
            }
            return this.validateClaims(clientConfiguration, openIdProviderMetadata, jwt.get(), nonce);
        }
        if (LOG.isErrorEnabled()) {
            LOG.error("JWT signature validation failed for provider [{}]", (Object)clientConfiguration.getName());
        }
        return Optional.empty();
    }

    @NonNull
    protected Optional<JWT> validateClaims(@NonNull OauthClientConfiguration clientConfiguration, @NonNull OpenIdProviderMetadata openIdProviderMetadata, @NonNull JWT jwt, @Nullable String nonce) {
        block12: {
            try {
                JWTClaimsSet claimsSet = jwt.getJWTClaimsSet();
                JWTOpenIdClaims claims = new JWTOpenIdClaims(claimsSet);
                if (this.genericJwtClaimsValidators.stream().allMatch(validator -> validator.validate((Claims)claims, null))) {
                    if (this.openIdClaimsValidators.stream().allMatch(validator -> validator.validate(claims, clientConfiguration, openIdProviderMetadata))) {
                        if (this.nonceClaimValidator == null) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Skipping nonce validation because no bean of type {} present. ", (Object)NonceClaimValidator.class.getSimpleName());
                            }
                            return Optional.of(jwt);
                        }
                        if (this.nonceClaimValidator.validate(claims, clientConfiguration, openIdProviderMetadata, nonce)) {
                            return Optional.of(jwt);
                        }
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Nonce {} validation failed for claims {}", (Object)nonce, (Object)claims.getClaims().keySet().stream().map(key -> key + "=" + claims.getClaims().get(key)).collect(Collectors.joining(", ", "{", "}")));
                        }
                    } else if (LOG.isErrorEnabled()) {
                        LOG.error("JWT OpenID specific claims validation failed for provider [{}]", (Object)clientConfiguration.getName());
                    }
                } else if (LOG.isErrorEnabled()) {
                    LOG.error("JWT generic claims validation failed for provider [{}]", (Object)clientConfiguration.getName());
                }
            }
            catch (ParseException e) {
                if (!LOG.isErrorEnabled()) break block12;
                LOG.error("Failed to parse the JWT returned from provider [{}]", (Object)clientConfiguration.getName(), (Object)e);
            }
        }
        return Optional.empty();
    }

    @NonNull
    protected Optional<JWT> parseJwtWithValidSignature(@NonNull OpenIdProviderMetadata openIdProviderMetadata, @NonNull OpenIdTokenResponse openIdTokenResponse) {
        return JwtValidator.builder().withSignatures(new SignatureConfiguration[]{this.jwksSignatureForOpenIdProviderMetadata(openIdProviderMetadata)}).build().validate(openIdTokenResponse.getIdToken(), null);
    }

    protected JwksSignature jwksSignatureForOpenIdProviderMetadata(@NonNull OpenIdProviderMetadata openIdProviderMetadata) {
        String jwksUri = openIdProviderMetadata.getJwksUri();
        this.jwksSignatures.computeIfAbsent(jwksUri, k -> {
            JwksSignatureConfigurationProperties config = new JwksSignatureConfigurationProperties(openIdProviderMetadata.getName());
            config.setUrl(jwksUri);
            return new JwksSignature((JwksSignatureConfiguration)config, this.jwkValidator, this.jwkSetFetcher);
        });
        return this.jwksSignatures.get(jwksUri);
    }
}

