/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.clientcredentials;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsConfiguration;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.utils.QualifierUtils;
import java.util.Optional;

@Internal
public class ClientCredentialsEnabled
implements Condition {
    public boolean matches(ConditionContext context) {
        AnnotationMetadataProvider component = context.getComponent();
        Optional nameOptional = QualifierUtils.nameQualifier((AnnotationMetadataProvider)component);
        if (nameOptional.isEmpty()) {
            return true;
        }
        String name = (String)nameOptional.get();
        OauthClientConfiguration clientConfiguration = (OauthClientConfiguration)context.getBean(OauthClientConfiguration.class, Qualifiers.byName((String)name));
        String failureMessage = "Client credentials is disabled for the client [" + name + "]";
        if (clientConfiguration.isEnabled()) {
            Optional<ClientCredentialsConfiguration> clientCredentialsConfiguration = clientConfiguration.getClientCredentials();
            if (clientCredentialsConfiguration.isEmpty() || clientCredentialsConfiguration.get().isEnabled()) {
                return true;
            }
            context.fail(failureMessage);
            return false;
        }
        context.fail(failureMessage);
        return false;
    }
}

