/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.userinfo;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.Named;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.validator.TokenValidator;
import java.io.Closeable;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Internal
final class UserInfoClientTokenValidator
implements Closeable,
TokenValidator<HttpRequest<?>>,
Named {
    private static final Logger LOG = LoggerFactory.getLogger(UserInfoClientTokenValidator.class);
    private static final Argument<Map<String, Object>> MAP_ARGUMENT = Argument.mapOf(String.class, Object.class);
    private final HttpClient httpClient;
    private final String path;
    private final String name;

    UserInfoClientTokenValidator(String name, HttpClient httpClient, String path) {
        this.name = name;
        this.httpClient = httpClient;
        this.path = path;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    @NonNull
    public Publisher<Authentication> validateToken(@NonNull String token, @Nullable HttpRequest<?> request) {
        return Mono.from((Publisher)this.httpClient.retrieve((HttpRequest)HttpRequest.GET((String)this.path).bearerAuth((CharSequence)token), MAP_ARGUMENT)).flatMap(m -> {
            Authentication authentication = UserInfoClientTokenValidator.createAuthentication(m);
            return authentication == null ? Mono.empty() : Mono.just((Object)authentication);
        }).onErrorResume(t -> {
            if (t instanceof HttpClientResponseException) {
                HttpClientResponseException ex = (HttpClientResponseException)t;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Token not validated. UserInfo endpoint for client {} responded with HTTP status code {} while validating the token", (Object)this.getName(), (Object)ex.getStatus().getCode());
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(t.getMessage(), t);
            }
            return Mono.empty();
        });
    }

    @Nullable
    private static Authentication createAuthentication(@NonNull Map<String, Object> claims) {
        Object subject = claims.get("sub");
        if (subject == null) {
            return null;
        }
        return Authentication.build((String)subject.toString(), claims);
    }

    public int getOrder() {
        return 2147483547;
    }
}

