/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.metadata;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.metadata.ProtectedResourceMetadata;
import io.micronaut.security.oauth2.metadata.ProtectedResourceMetadataProvider;
import jakarta.inject.Singleton;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@Requires(classes={HttpRequest.class})
@Singleton
public class DefaultProtectedResourceMetadataProvider
implements ProtectedResourceMetadataProvider<HttpRequest<?>> {
    protected final ApplicationConfiguration applicationConfiguration;
    protected final HttpHostResolver httpHostResolver;
    protected final List<OpenIdClientConfiguration> openIdClients;

    public DefaultProtectedResourceMetadataProvider(ApplicationConfiguration applicationConfiguration, HttpHostResolver httpHostResolver, List<OpenIdClientConfiguration> openIdClients) {
        this.applicationConfiguration = applicationConfiguration;
        this.httpHostResolver = httpHostResolver;
        this.openIdClients = openIdClients;
    }

    @Override
    @NonNull
    public ProtectedResourceMetadata get(@NonNull HttpRequest<?> request) {
        return this.builder(null, request).build();
    }

    @Override
    @NonNull
    public ProtectedResourceMetadata get(@NonNull String path, @NonNull HttpRequest<?> request) {
        return this.builder(path, request).build();
    }

    @NonNull
    protected ProtectedResourceMetadata.Builder builder(@Nullable String path, @NonNull HttpRequest<?> request) {
        ProtectedResourceMetadata.Builder builder = ProtectedResourceMetadata.builder().resource(this.resource(path, request));
        List<String> authorizationServers = this.authorizationServers(path, request);
        if (CollectionUtils.isNotEmpty(authorizationServers)) {
            builder.authorizationServers(authorizationServers);
        }
        this.applicationConfiguration.getName().ifPresent(builder::resourceName);
        return builder;
    }

    @NonNull
    protected String resource(@Nullable String path, @NonNull HttpRequest<?> request) {
        String host = this.httpHostResolver.resolve(request);
        return StringUtils.isNotEmpty((CharSequence)path) ? host + path : host;
    }

    @NonNull
    protected List<String> authorizationServers(@Nullable String path, @NonNull HttpRequest<?> request) {
        ArrayList<String> result = new ArrayList<String>(this.openIdClients.size());
        for (OpenIdClientConfiguration openIdClientConfiguration : this.openIdClients) {
            if (!openIdClientConfiguration.isProtectedResourceMetadata()) continue;
            openIdClientConfiguration.getIssuer().map(URL::toString).ifPresent(result::add);
        }
        return result;
    }
}

