/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.proxy;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.client.ProxyHttpClient;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.proxy.WellKnownProxyFilterCondition;
import io.micronaut.security.oauth2.proxy.WellKnownProxySettings;
import jakarta.annotation.Nullable;
import java.net.URL;
import java.util.List;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(condition=WellKnownProxyFilterCondition.class), @Requires(classes={HttpRequest.class}), @Requires(beans={ProxyHttpClient.class})})
@Filter(value={"/.well-known/oauth-authorization-server|/.well-known/openid-configuration"}, patternStyle=FilterPatternStyle.REGEX)
@Internal
final class WellKnownProxyFilter
implements HttpServerFilter {
    static final String OAUTH_AUTHORIZATION_SERVER_WELL_KNOWN_PATH = "/.well-known/oauth-authorization-server";
    static final String OPENID_CONFIGURATION_PATH = "/.well-known/openid-configuration";
    @Nullable
    private final WellKnownProxySettings settings;
    private final ProxyHttpClient proxyHttpClient;

    WellKnownProxyFilter(List<OauthClientConfiguration> oauthClientConfigurations, ProxyHttpClient proxyHttpClient) {
        this.settings = WellKnownProxyFilterCondition.issuer(oauthClientConfigurations);
        this.proxyHttpClient = proxyHttpClient;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        if (this.proceed(request)) {
            return chain.proceed(request);
        }
        URL issuer = this.settings.issuer();
        return this.proxyHttpClient.proxy((HttpRequest)request.mutate().uri(b -> b.host(issuer.getHost()).scheme(issuer.getProtocol()).port(issuer.getPort())));
    }

    boolean proceed(@NonNull HttpRequest<?> request) {
        return this.settings == null || this.settings.issuer() == null || request.getMethod() != HttpMethod.GET || request.getPath().equals(OPENID_CONFIGURATION_PATH) && !this.settings.proxyWellKnownOpenidConfiguration() || request.getPath().equals(OAUTH_AUTHORIZATION_SERVER_WELL_KNOWN_PATH) && !this.settings.proxyWellKnownOauthAuthorizationServer();
    }
}

