/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.proxy;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.oauth2.proxy.WellKnownProxyFilterCondition;
import io.micronaut.security.rules.SecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import jakarta.inject.Singleton;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(condition=WellKnownProxyFilterCondition.class), @Requires(classes={HttpRequest.class})})
@Singleton
@Internal
final class WellKnownProxySecurityRule
implements SecurityRule<HttpRequest<?>> {
    WellKnownProxySecurityRule() {
    }

    @NonNull
    public Publisher<SecurityRuleResult> check(@Nullable HttpRequest<?> request, @Nullable Authentication authentication) {
        if (request == null) {
            return Publishers.just((Object)SecurityRuleResult.UNKNOWN);
        }
        String path = request.getPath();
        if (request.getMethod().equals((Object)HttpMethod.GET) && (path.equals("/.well-known/oauth-authorization-server") || path.equals("/.well-known/openid-configuration"))) {
            return Publishers.just((Object)SecurityRuleResult.ALLOWED);
        }
        return Publishers.just((Object)SecurityRuleResult.UNKNOWN);
    }
}

