/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.pkce;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.Pkce;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceChallenge;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceFactory;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceGenerator;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.persistence.PkcePersistence;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;

@Singleton
public class DefaultPkceFactory
implements PkceFactory {
    @NonNull
    private final List<PkceGenerator> generators;
    @NonNull
    private final PkcePersistence persistence;

    public DefaultPkceFactory(@NonNull List<PkceGenerator> generators, @NonNull PkcePersistence persistence) {
        this.generators = generators;
        this.persistence = persistence;
    }

    @Override
    @NonNull
    public Optional<PkceChallenge> buildChallenge(@NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<?> response, @Nullable List<String> supportedChallengeMethods) {
        if (CollectionUtils.isEmpty(this.generators) || CollectionUtils.isEmpty(supportedChallengeMethods)) {
            return Optional.empty();
        }
        Optional<Pkce> pkceOptional = this.generators.stream().filter(gen -> gen.supportsAny(supportedChallengeMethods)).map(PkceGenerator::generate).findFirst();
        pkceOptional.ifPresent(chal -> this.persistence.persistPkce(request, response, (Pkce)chal));
        return pkceOptional.map(PkceChallenge.class::cast);
    }
}

