/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response.validation;

import io.micronaut.context.annotation.Requires;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdClaimsValidator;
import jakarta.inject.Singleton;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(property="micronaut.security.oauth2.openid.claims-validation.audience", notEquals="false")
@Singleton
public class AudienceClaimValidator
implements OpenIdClaimsValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AudienceClaimValidator.class);

    @Override
    public boolean validate(OpenIdClaims claims, OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata providerMetadata) {
        List<String> audienceList = claims.getAudience();
        boolean condition = audienceList.stream().anyMatch(audience -> audience.equals(clientConfiguration.getClientId()));
        if (!condition) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JWT validation failed for provider [{}]. Audience claims does not contain [{}]", (Object)clientConfiguration.getName(), (Object)clientConfiguration.getClientId());
            }
            return false;
        }
        if (audienceList.size() > 1 && claims.getAuthorizedParty() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JWT validation failed for provider [{}]. Multiple audience claims present but no authorized party", (Object)clientConfiguration.getName());
            }
            return false;
        }
        return true;
    }
}

