/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.session;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.functional.ThrowingSupplier;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.config.RedirectService;
import io.micronaut.security.errors.PriorToLoginPersistence;
import io.micronaut.security.handlers.RedirectingLoginHandler;
import io.micronaut.security.session.DefaultSessionPopulator;
import io.micronaut.security.session.SessionAuthenticationModeCondition;
import io.micronaut.security.session.SessionPopulator;
import io.micronaut.session.Session;
import io.micronaut.session.SessionStore;
import io.micronaut.session.http.SessionForRequest;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;

@Requires(condition=SessionAuthenticationModeCondition.class)
@Singleton
public class SessionLoginHandler
implements RedirectingLoginHandler<HttpRequest<?>, MutableHttpResponse<?>> {
    @Nullable
    protected final String loginSuccess;
    @Nullable
    protected final String loginFailure;
    protected final RedirectConfiguration redirectConfiguration;
    protected final SessionStore<Session> sessionStore;
    private final PriorToLoginPersistence<HttpRequest<?>, MutableHttpResponse<?>> priorToLoginPersistence;
    private final List<SessionPopulator<HttpRequest<?>>> sessionPopulators;

    @Inject
    public SessionLoginHandler(RedirectConfiguration redirectConfiguration, SessionStore<Session> sessionStore, @Nullable PriorToLoginPersistence<HttpRequest<?>, MutableHttpResponse<?>> priorToLoginPersistence, RedirectService redirectService, List<SessionPopulator<HttpRequest<?>>> sessionPopulators) {
        this.loginFailure = redirectConfiguration.isEnabled() ? redirectService.loginFailureUrl() : null;
        this.loginSuccess = redirectConfiguration.isEnabled() ? redirectService.loginSuccessUrl() : null;
        this.redirectConfiguration = redirectConfiguration;
        this.sessionStore = sessionStore;
        this.priorToLoginPersistence = priorToLoginPersistence;
        this.sessionPopulators = sessionPopulators;
    }

    @Deprecated(forRemoval=true, since="4.11.0")
    public SessionLoginHandler(RedirectConfiguration redirectConfiguration, SessionStore<Session> sessionStore, @Nullable PriorToLoginPersistence<HttpRequest<?>, MutableHttpResponse<?>> priorToLoginPersistence, RedirectService redirectService) {
        this(redirectConfiguration, sessionStore, priorToLoginPersistence, redirectService, List.of(new DefaultSessionPopulator()));
    }

    public MutableHttpResponse<?> loginSuccess(Authentication authentication, HttpRequest<?> request) {
        this.saveAuthenticationInSession(authentication, request);
        return this.loginSuccessResponse(request);
    }

    public MutableHttpResponse<?> loginRefresh(Authentication authentication, String refreshToken, HttpRequest<?> request) {
        throw new UnsupportedOperationException("Session based logins do not support refresh");
    }

    public MutableHttpResponse<?> loginFailed(AuthenticationResponse authenticationFailed, HttpRequest<?> request) {
        if (this.loginFailure == null) {
            return HttpResponse.ok();
        }
        try {
            URI location = new URI(this.loginFailure);
            return HttpResponse.seeOther((URI)location);
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    @NonNull
    private MutableHttpResponse<?> loginSuccessResponse(HttpRequest<?> request) {
        if (this.loginSuccess == null) {
            return HttpResponse.ok();
        }
        try {
            MutableHttpResponse response = HttpResponse.status((HttpStatus)HttpStatus.SEE_OTHER);
            response.getHeaders().location((URI)this.loginSuccessUriSupplier(this.loginSuccess, request, response).get());
            return response;
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    @NonNull
    private ThrowingSupplier<URI, URISyntaxException> loginSuccessUriSupplier(@NonNull String loginSuccess, HttpRequest<?> request, @NonNull MutableHttpResponse<?> response) {
        Optional originalUri;
        ThrowingSupplier uriSupplier = () -> new URI(loginSuccess);
        if (this.priorToLoginPersistence != null && (originalUri = this.priorToLoginPersistence.getOriginalUri(request, response)).isPresent()) {
            uriSupplier = originalUri::get;
        }
        return uriSupplier;
    }

    private void saveAuthenticationInSession(Authentication authentication, HttpRequest<?> request) {
        Session session = SessionForRequest.find(request).orElseGet(() -> SessionForRequest.create(this.sessionStore, (HttpRequest)request));
        this.sessionPopulators.forEach(sessionPopulator -> sessionPopulator.populateSession(request, authentication, session));
    }
}

