/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.config.AuthenticationStrategy;
import io.micronaut.security.config.SecurityConfiguration;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.exceptions.CompositeException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(Authenticator.class);
    protected final Collection<AuthenticationProvider> authenticationProviders;
    private final SecurityConfiguration securityConfiguration;

    public Authenticator(Collection<AuthenticationProvider> authenticationProviders, SecurityConfiguration securityConfiguration) {
        this.authenticationProviders = authenticationProviders;
        this.securityConfiguration = securityConfiguration;
    }

    public Publisher<AuthenticationResponse> authenticate(HttpRequest<?> request, AuthenticationRequest<?, ?> authenticationRequest) {
        if (this.authenticationProviders == null) {
            return Flowable.empty();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.authenticationProviders.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining()));
        }
        if (this.securityConfiguration != null && this.securityConfiguration.getAuthenticationProviderStrategy() == AuthenticationStrategy.ALL) {
            return Flowable.mergeDelayError((Iterable)this.authenticationProviders.stream().map(provider -> Flowable.fromPublisher(provider.authenticate(request, authenticationRequest)).switchMap(response -> {
                if (response.isAuthenticated()) {
                    return Flowable.just((Object)response);
                }
                return Flowable.error(() -> new AuthenticationException((AuthenticationResponse)response));
            }).switchIfEmpty((Publisher)Flowable.error(() -> new AuthenticationException("Provider did not respond. Authentication rejected")))).collect(Collectors.toList())).lastOrError().onErrorReturn(t -> {
                if (t instanceof CompositeException) {
                    List exceptions = ((CompositeException)t).getExceptions();
                    return new AuthenticationFailed(((Throwable)exceptions.get(exceptions.size() - 1)).getMessage());
                }
                return new AuthenticationFailed(t.getMessage());
            }).toFlowable();
        }
        AtomicReference lastError = new AtomicReference();
        Flowable authentication = Flowable.mergeDelayError((Iterable)this.authenticationProviders.stream().map(auth -> auth.authenticate(request, authenticationRequest)).map(Flowable::fromPublisher).map(flow -> flow.switchMap(response -> {
            if (response.isAuthenticated()) {
                return Flowable.just((Object)response);
            }
            return Flowable.error((Throwable)new AuthenticationException((AuthenticationResponse)response));
        }).onErrorResumeNext(t -> {
            lastError.set(t);
            return Flowable.empty();
        })).collect(Collectors.toList()));
        return authentication.take(1L).switchIfEmpty((Publisher)Flowable.create(emitter -> {
            Throwable error = (Throwable)lastError.get();
            if (error != null) {
                if (error instanceof AuthenticationException) {
                    AuthenticationResponse response = ((AuthenticationException)error).getResponse();
                    if (response != null) {
                        emitter.onNext((Object)response);
                        emitter.onComplete();
                    } else {
                        emitter.onError(error);
                    }
                } else {
                    emitter.onError(error);
                }
            } else {
                emitter.onComplete();
            }
        }, (BackpressureStrategy)BackpressureStrategy.ERROR));
    }
}

