/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints.introspection;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.endpoints.introspection.IntrospectionProcessor;
import io.micronaut.security.endpoints.introspection.IntrospectionRequest;
import io.micronaut.security.endpoints.introspection.IntrospectionResponse;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.security.token.validator.RefreshTokenValidator;
import io.micronaut.security.token.validator.TokenValidator;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Singleton
public class DefaultIntrospectionProcessor<T>
implements IntrospectionProcessor<T> {
    public static final String CLIENT_ID = "client_id";
    public static final String USERNAME = "username";
    public static final String TOKEN_TYPE = "token_type";
    public static final String ISSUER = "iss";
    public static final String SUBJECT = "sub";
    public static final String EXP = "exp";
    public static final String NOT_BEFORE = "nbf";
    public static final String ISSUED_AT = "iat";
    public static final String JWT_ID = "jti";
    public static final String AUDIENCE = "aud";
    public static final String SCOPE = "scope";
    public static final List<String> FIELDS_ATTRIBUTE_NAMES = Arrays.asList("scope", "username", "client_id", "token_type", "exp", "iat", "sub", "nbf", "aud", "iss", "jti");
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultIntrospectionProcessor.class);
    protected final Collection<TokenValidator<T>> tokenValidators;
    protected final TokenConfiguration tokenConfiguration;
    protected final RefreshTokenValidator refreshTokenValidator;

    public DefaultIntrospectionProcessor(Collection<TokenValidator<T>> tokenValidators, TokenConfiguration tokenConfiguration, @Nullable RefreshTokenValidator refreshTokenValidator) {
        this.tokenValidators = tokenValidators;
        this.tokenConfiguration = tokenConfiguration;
        this.refreshTokenValidator = refreshTokenValidator;
    }

    @Override
    @NonNull
    public Publisher<IntrospectionResponse> introspect(@NonNull IntrospectionRequest introspectionRequest, @NonNull T httpRequest) {
        String token = introspectionRequest.getToken();
        return Flux.fromIterable(this.tokenValidators).flatMap(tokenValidator -> tokenValidator.validateToken(token, httpRequest)).next().map(authentication -> this.createIntrospectionResponse((Authentication)authentication, httpRequest)).defaultIfEmpty((Object)this.emptyIntrospectionResponse(token)).flux();
    }

    @NonNull
    protected IntrospectionResponse emptyIntrospectionResponse(@NonNull String token) {
        return new IntrospectionResponse(this.refreshTokenValidator != null && this.refreshTokenValidator.validate(token).isPresent(), null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Override
    @NonNull
    public Publisher<IntrospectionResponse> introspect(@NonNull Authentication authentication, @NonNull T httpRequest) {
        return Flux.just((Object)this.createIntrospectionResponse(authentication, httpRequest));
    }

    @NonNull
    public IntrospectionResponse createIntrospectionResponse(@NonNull Authentication authentication, @NonNull T httpRequest) {
        return new IntrospectionResponse(true, this.resolveTokenType(authentication).orElse(null), this.resolveScope(authentication).orElse(null), this.resolveClientId(authentication).orElse(null), this.resolveUsername(authentication).orElse(authentication.getName()), this.resolveExpiration(authentication).orElse(null), this.resolveIssuedAt(authentication).orElse(null), this.resolveNotBefore(authentication).orElse(null), this.resolveSub(authentication), this.resolveAud(authentication).orElse(null), this.resolveIssuer(authentication).orElse(null), this.resolveJwtId(authentication).orElse(null), this.resolveExtensions(authentication));
    }

    @NonNull
    protected Map<String, Object> resolveExtensions(@NonNull Authentication authentication) {
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        for (String k : authentication.getAttributes().keySet()) {
            if (FIELDS_ATTRIBUTE_NAMES.contains(k)) continue;
            extensions.put(k, authentication.getAttributes().get(k));
        }
        if (!extensions.containsKey(this.tokenConfiguration.getRolesName())) {
            extensions.put(this.tokenConfiguration.getRolesName(), new ArrayList<String>(authentication.getRoles()));
        }
        return extensions;
    }

    protected Optional<String> resolveScope(@NonNull Authentication authentication) {
        return authentication.getAttributes().containsKey(SCOPE) ? Optional.of(authentication.getAttributes().get(SCOPE).toString()) : Optional.empty();
    }

    @NonNull
    protected Optional<String> resolveTokenType(@NonNull Authentication authentication) {
        return authentication.getAttributes().containsKey(TOKEN_TYPE) ? Optional.of(authentication.getAttributes().get(TOKEN_TYPE).toString()) : Optional.empty();
    }

    @NonNull
    protected Optional<String> resolveClientId(@NonNull Authentication authentication) {
        return authentication.getAttributes().containsKey(CLIENT_ID) ? Optional.of(authentication.getAttributes().get(CLIENT_ID).toString()) : Optional.empty();
    }

    @NonNull
    protected Optional<String> resolveAud(@NonNull Authentication authentication) {
        return authentication.getAttributes().containsKey(AUDIENCE) ? Optional.of(authentication.getAttributes().get(AUDIENCE).toString()) : Optional.empty();
    }

    @NonNull
    protected String resolveSub(@NonNull Authentication authentication) {
        return authentication.getAttributes().containsKey(SUBJECT) ? authentication.getAttributes().get(SUBJECT).toString() : authentication.getName();
    }

    @NonNull
    protected Optional<String> resolveIssuer(@NonNull Authentication authentication) {
        return authentication.getAttributes().containsKey(ISSUER) ? Optional.of(authentication.getAttributes().get(ISSUER).toString()) : Optional.empty();
    }

    @NonNull
    protected Optional<String> resolveJwtId(@NonNull Authentication authentication) {
        return authentication.getAttributes().containsKey(JWT_ID) ? Optional.of(authentication.getAttributes().get(JWT_ID).toString()) : Optional.empty();
    }

    @NonNull
    protected Optional<String> resolveUsername(@NonNull Authentication authentication) {
        return authentication.getAttributes().containsKey(USERNAME) ? Optional.of(authentication.getAttributes().get(USERNAME).toString()) : Optional.empty();
    }

    protected Optional<Long> resolveExpiration(@NonNull Authentication authentication) {
        return this.secondsSinceEpochOfAttribute(EXP, authentication);
    }

    protected Optional<Long> secondsSinceEpochOfAttribute(@NonNull String attributeName, @NonNull Authentication authentication) {
        block5: {
            if (authentication.getAttributes().containsKey(attributeName)) {
                Object obj = authentication.getAttributes().get(attributeName);
                if (obj instanceof Long) {
                    return Optional.of((Long)obj);
                }
                if (obj instanceof Date) {
                    return Optional.of(DefaultIntrospectionProcessor.toSecondsSinceEpoch((Date)obj));
                }
                try {
                    return Optional.of(Long.valueOf(obj.toString()));
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) break block5;
                    LOG.warn("cannot convert attribute {} with value {} to Integer", (Object)attributeName, obj);
                }
            }
        }
        return Optional.empty();
    }

    @NonNull
    protected Optional<Long> resolveNotBefore(@NonNull Authentication authentication) {
        return this.secondsSinceEpochOfAttribute(NOT_BEFORE, authentication);
    }

    @NonNull
    protected Optional<Long> resolveIssuedAt(@NonNull Authentication authentication) {
        return this.secondsSinceEpochOfAttribute(ISSUED_AT, authentication);
    }

    public static long toSecondsSinceEpoch(Date date) {
        return date.getTime() / 1000L;
    }
}

