/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.reader;

import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.token.reader.TokenReader;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpHeaderTokenReader
implements TokenReader<HttpRequest<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpHeaderTokenReader.class);

    protected abstract String getPrefix();

    protected abstract String getHeaderName();

    @Override
    public Optional<String> findToken(HttpRequest<?> request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for bearer token in {} header", (Object)this.getHeaderName());
        }
        HttpHeaders headers = request.getHeaders();
        Optional authorizationHeader = headers.findFirst((CharSequence)this.getHeaderName());
        return authorizationHeader.flatMap(this::extractTokenFromAuthorization);
    }

    protected Optional<String> extractTokenFromAuthorization(String authorization) {
        StringBuilder sb = new StringBuilder();
        String prefix = this.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            sb.append(prefix);
            sb.append(" ");
        }
        String str = sb.toString().toLowerCase(Locale.ROOT);
        if (authorization.toLowerCase(Locale.ROOT).startsWith(str)) {
            return Optional.of(authorization.substring(str.length()));
        }
        LOG.debug("{} does not start with {}", (Object)authorization, (Object)str);
        return Optional.empty();
    }
}

