/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.cookie;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.config.RedirectService;
import io.micronaut.security.errors.OauthErrorResponseException;
import io.micronaut.security.errors.ObtainingAuthorizationErrorCode;
import io.micronaut.security.errors.PriorToLoginPersistence;
import io.micronaut.security.token.cookie.AccessTokenCookieConfiguration;
import io.micronaut.security.token.cookie.CookieLoginHandler;
import io.micronaut.security.token.cookie.LoginCookieProvider;
import io.micronaut.security.token.cookie.RefreshTokenCookieConfiguration;
import io.micronaut.security.token.generator.AccessRefreshTokenGenerator;
import io.micronaut.security.token.generator.AccessTokenConfiguration;
import io.micronaut.security.token.render.AccessRefreshToken;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Requirements(value={@Requires(classes={HttpRequest.class}), @Requires(property="micronaut.security.authentication", value="cookie")})
@Singleton
public class TokenCookieLoginHandler
extends CookieLoginHandler {
    protected final AccessRefreshTokenGenerator accessRefreshTokenGenerator;
    protected final RefreshTokenCookieConfiguration refreshTokenCookieConfiguration;
    protected final AccessTokenConfiguration accessTokenConfiguration;
    private final List<LoginCookieProvider<HttpRequest<?>>> loginCookieProviders;

    @Inject
    public TokenCookieLoginHandler(RedirectService redirectService, RedirectConfiguration redirectConfiguration, AccessTokenCookieConfiguration accessTokenCookieConfiguration, RefreshTokenCookieConfiguration refreshTokenCookieConfiguration, AccessTokenConfiguration accessTokenConfiguration, AccessRefreshTokenGenerator accessRefreshTokenGenerator, @Nullable PriorToLoginPersistence<HttpRequest<?>, MutableHttpResponse<?>> priorToLoginPersistence, List<LoginCookieProvider<HttpRequest<?>>> loginCookieProviders) {
        super(accessTokenCookieConfiguration, redirectConfiguration, redirectService, priorToLoginPersistence);
        this.refreshTokenCookieConfiguration = refreshTokenCookieConfiguration;
        this.accessTokenConfiguration = accessTokenConfiguration;
        this.accessRefreshTokenGenerator = accessRefreshTokenGenerator;
        this.loginCookieProviders = loginCookieProviders;
    }

    @Deprecated(forRemoval=true, since="4.11.0")
    public TokenCookieLoginHandler(RedirectService redirectService, RedirectConfiguration redirectConfiguration, AccessTokenCookieConfiguration accessTokenCookieConfiguration, RefreshTokenCookieConfiguration refreshTokenCookieConfiguration, AccessTokenConfiguration accessTokenConfiguration, AccessRefreshTokenGenerator accessRefreshTokenGenerator, @Nullable PriorToLoginPersistence<HttpRequest<?>, MutableHttpResponse<?>> priorToLoginPersistence) {
        this(redirectService, redirectConfiguration, accessTokenCookieConfiguration, refreshTokenCookieConfiguration, accessTokenConfiguration, accessRefreshTokenGenerator, priorToLoginPersistence, Collections.emptyList());
    }

    @Override
    public List<Cookie> getCookies(Authentication authentication, HttpRequest<?> request) {
        AccessRefreshToken accessRefreshToken = this.accessRefreshTokenGenerator.generate(authentication).orElseThrow(() -> new OauthErrorResponseException(ObtainingAuthorizationErrorCode.SERVER_ERROR, "Cannot obtain an access token", null));
        return this.getCookies(accessRefreshToken, request);
    }

    @Override
    public List<Cookie> getCookies(Authentication authentication, String refreshToken, HttpRequest<?> request) {
        AccessRefreshToken accessRefreshToken = this.accessRefreshTokenGenerator.generate(refreshToken, authentication).orElseThrow(() -> new OauthErrorResponseException(ObtainingAuthorizationErrorCode.SERVER_ERROR, "Cannot obtain an access token", null));
        return this.getCookies(accessRefreshToken, request);
    }

    protected List<Cookie> getCookies(AccessRefreshToken accessRefreshToken, HttpRequest<?> request) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(2);
        Cookie jwtCookie = Cookie.of((String)this.accessTokenCookieConfiguration.getCookieName(), (String)accessRefreshToken.getAccessToken());
        jwtCookie.configure((CookieConfiguration)this.accessTokenCookieConfiguration, request.isSecure());
        TemporalAmount maxAge = this.accessTokenCookieConfiguration.getCookieMaxAge().orElseGet(() -> Duration.ofSeconds(this.accessTokenConfiguration.getExpiration().intValue()));
        jwtCookie.maxAge(maxAge);
        cookies.add(jwtCookie);
        String refreshToken = accessRefreshToken.getRefreshToken();
        if (StringUtils.isNotEmpty((CharSequence)refreshToken)) {
            Cookie refreshCookie = Cookie.of((String)this.refreshTokenCookieConfiguration.getCookieName(), (String)refreshToken);
            refreshCookie.configure((CookieConfiguration)this.refreshTokenCookieConfiguration, request.isSecure());
            refreshCookie.maxAge(this.refreshTokenCookieConfiguration.getCookieMaxAge().orElseGet(() -> Duration.ofDays(30L)));
            cookies.add(refreshCookie);
        }
        for (LoginCookieProvider<HttpRequest<?>> loginCookieProvider : this.loginCookieProviders) {
            cookies.add(loginCookieProvider.provideCookie(request));
        }
        return cookies;
    }
}

