/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.server.util.locale.HttpLocaleResolver;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.Authenticator;
import io.micronaut.security.authentication.UsernamePasswordCredentials;
import io.micronaut.security.endpoints.LoginControllerConfiguration;
import io.micronaut.security.endpoints.LoginControllerConfigurationProperties;
import io.micronaut.security.event.LoginFailedEvent;
import io.micronaut.security.event.LoginSuccessfulEvent;
import io.micronaut.security.handlers.LoginHandler;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import java.util.Locale;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Requirements(value={@Requires(property="micronaut.security.endpoints.login.enabled", notEquals="false", defaultValue="true"), @Requires(classes={Controller.class}), @Requires(beans={LoginHandler.class, Authenticator.class, HttpHostResolver.class, HttpHostResolver.class})})
@Controller(value="${micronaut.security.endpoints.login.path:/login}")
@Secured(value={"isAnonymous()"})
public class LoginController<B> {
    private static final Logger LOG = LoggerFactory.getLogger(LoginController.class);
    protected final Authenticator<HttpRequest<B>> authenticator;
    protected final LoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler;
    protected final ApplicationEventPublisher<LoginSuccessfulEvent> loginSuccessfulEventPublisher;
    protected final ApplicationEventPublisher<LoginFailedEvent> loginFailedEventPublisher;
    protected final HttpHostResolver httpHostResolver;
    protected final HttpLocaleResolver httpLocaleResolver;
    protected final LoginControllerConfiguration loginControllerConfiguration;

    @Inject
    public LoginController(Authenticator<HttpRequest<B>> authenticator, LoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler, ApplicationEventPublisher<LoginSuccessfulEvent> loginSuccessfulEventPublisher, ApplicationEventPublisher<LoginFailedEvent> loginFailedEventPublisher, HttpHostResolver httpHostResolver, HttpLocaleResolver httpLocaleResolver, LoginControllerConfiguration loginControllerConfiguration) {
        this.authenticator = authenticator;
        this.loginHandler = loginHandler;
        this.loginSuccessfulEventPublisher = loginSuccessfulEventPublisher;
        this.loginFailedEventPublisher = loginFailedEventPublisher;
        this.httpHostResolver = httpHostResolver;
        this.httpLocaleResolver = httpLocaleResolver;
        this.loginControllerConfiguration = loginControllerConfiguration;
    }

    @Deprecated(forRemoval=true, since="4.11.0")
    public LoginController(Authenticator<HttpRequest<B>> authenticator, LoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler, ApplicationEventPublisher<LoginSuccessfulEvent> loginSuccessfulEventPublisher, ApplicationEventPublisher<LoginFailedEvent> loginFailedEventPublisher, HttpHostResolver httpHostResolver, HttpLocaleResolver httpLocaleResolver) {
        this(authenticator, loginHandler, loginSuccessfulEventPublisher, loginFailedEventPublisher, httpHostResolver, httpLocaleResolver, new LoginControllerConfigurationProperties());
    }

    @Deprecated(forRemoval=true, since="4.7.0")
    public LoginController(Authenticator<HttpRequest<B>> authenticator, LoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler, ApplicationEventPublisher<LoginSuccessfulEvent> loginSuccessfulEventPublisher, ApplicationEventPublisher<LoginFailedEvent> loginFailedEventPublisher) {
        this(authenticator, loginHandler, loginSuccessfulEventPublisher, loginFailedEventPublisher, request -> null, new HttpLocaleResolver(){

            @NonNull
            public Optional<Locale> resolve(@NonNull HttpRequest<?> context) {
                return Optional.of(Locale.getDefault());
            }

            @NonNull
            public Locale resolveOrDefault(@NonNull HttpRequest<?> context) {
                return Locale.getDefault();
            }
        }, new LoginControllerConfigurationProperties());
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    @SingleResult
    public Publisher<MutableHttpResponse<?>> login(@Valid @Body UsernamePasswordCredentials usernamePasswordCredentials, HttpRequest<B> request) {
        Optional contentTypeOptional = request.getContentType();
        if (!contentTypeOptional.isPresent() || !this.loginControllerConfiguration.getPostContentTypes().contains(((MediaType)contentTypeOptional.get()).toString())) {
            return Publishers.just((Object)HttpResponse.notFound());
        }
        return Flux.from(this.authenticator.authenticate(request, usernamePasswordCredentials)).map(authenticationResponse -> {
            if (authenticationResponse.isAuthenticated() && authenticationResponse.getAuthentication().isPresent()) {
                Authentication authentication = authenticationResponse.getAuthentication().get();
                this.loginSuccessfulEventPublisher.publishEvent((Object)new LoginSuccessfulEvent(authentication, this.httpHostResolver.resolve(request), this.httpLocaleResolver.resolveOrDefault((Object)request)));
                return this.loginHandler.loginSuccess(authentication, request);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("login failed for username: {}", (Object)usernamePasswordCredentials.getUsername());
            }
            this.loginFailedEventPublisher.publishEvent((Object)new LoginFailedEvent(authenticationResponse, usernamePasswordCredentials, this.httpHostResolver.resolve(request), this.httpLocaleResolver.resolveOrDefault((Object)request)));
            return this.loginHandler.loginFailed((AuthenticationResponse)authenticationResponse, request);
        }).switchIfEmpty((Publisher)Mono.defer(() -> Mono.just((Object)HttpResponse.status((HttpStatus)HttpStatus.UNAUTHORIZED))));
    }
}

