/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.session;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.session.SessionIdResolver;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;

@Internal
@Primary
@Singleton
final class CompositeSessionIdResolver<T>
implements SessionIdResolver<T> {
    private final List<SessionIdResolver<T>> sessionIdResolvers;

    public CompositeSessionIdResolver(List<SessionIdResolver<T>> sessionIdResolvers) {
        this.sessionIdResolvers = sessionIdResolvers;
    }

    @Override
    @NonNull
    public Optional<String> findSessionId(@NonNull T request) {
        return this.sessionIdResolvers.stream().flatMap(sessionIdResolver -> sessionIdResolver.findSessionId(request).stream()).findFirst();
    }
}

