/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.utils;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

@Internal
public final class HMacUtils {
    private static final String HMAC_SHA256 = "HmacSHA256";

    private HMacUtils() {
    }

    public static String base64EncodedHmacSha256(@NonNull String data, @NonNull String key) throws NoSuchAlgorithmException, InvalidKeyException {
        return HMacUtils.base64EncodedHmac(HMAC_SHA256, data, key);
    }

    public static String base64EncodedHmac(@NonNull String algorithm, @NonNull String data, @NonNull String key) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), algorithm);
        Mac mac = Mac.getInstance(algorithm);
        mac.init(secretKeySpec);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(mac.doFinal(data.getBytes()));
    }
}

