/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints.introspection;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.serde.annotation.Serdeable;
import java.util.HashMap;
import java.util.Map;

@ReflectiveAccess
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Serdeable
public class IntrospectionResponse {
    private final boolean active;
    @Nullable
    private final String scope;
    @JsonProperty(value="client_id")
    @Nullable
    private final String clientId;
    @Nullable
    private final String username;
    @JsonProperty(value="token_type")
    @Nullable
    private final String tokenType;
    @Nullable
    private final Long exp;
    @Nullable
    private final Long iat;
    @Nullable
    private final Long nbf;
    @Nullable
    private final String sub;
    @Nullable
    private final String aud;
    @Nullable
    private final String iss;
    @Nullable
    private final String jti;
    @NonNull
    private final Map<String, Object> extensions = new HashMap<String, Object>();

    public IntrospectionResponse(boolean active, @Nullable String tokenType, @Nullable String scope, @Nullable String clientId, @Nullable String username, @Nullable Long exp, @Nullable Long iat, @Nullable Long nbf, @Nullable String sub, @Nullable String aud, @Nullable String iss, @Nullable String jti, @Nullable Map<String, Object> extensions) {
        this.active = active;
        this.tokenType = tokenType;
        this.scope = scope;
        this.clientId = clientId;
        this.username = username;
        this.exp = exp;
        this.iat = iat;
        this.nbf = nbf;
        this.sub = sub;
        this.aud = aud;
        this.iss = iss;
        this.jti = jti;
        if (extensions != null) {
            this.extensions.putAll(extensions);
        }
    }

    @JsonAnySetter
    public void addExtension(String key, Object value) {
        this.extensions.put(key, value);
    }

    @JsonAnyGetter
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public boolean isActive() {
        return this.active;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getTokenType() {
        return this.tokenType;
    }

    @Nullable
    public Long getExp() {
        return this.exp;
    }

    @Nullable
    public Long getIat() {
        return this.iat;
    }

    @Nullable
    public Long getNbf() {
        return this.nbf;
    }

    @Nullable
    public String getSub() {
        return this.sub;
    }

    @Nullable
    public String getAud() {
        return this.aud;
    }

    @Nullable
    public String getIss() {
        return this.iss;
    }

    @Nullable
    public String getJti() {
        return this.jti;
    }
}

