/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface Decoder
extends AutoCloseable {
    @NonNull
    public Decoder decodeArray(Argument<?> var1) throws IOException;

    @NonNull
    default public Decoder decodeArray() throws IOException {
        return this.decodeArray(Argument.OBJECT_ARGUMENT);
    }

    public boolean hasNextArrayValue() throws IOException;

    @NonNull
    public Decoder decodeObject(@NonNull Argument<?> var1) throws IOException;

    @NonNull
    default public Decoder decodeObject() throws IOException {
        return this.decodeObject(Argument.OBJECT_ARGUMENT);
    }

    @Nullable
    public String decodeKey() throws IOException;

    @NonNull
    public String decodeString() throws IOException;

    public boolean decodeBoolean() throws IOException;

    public byte decodeByte() throws IOException;

    public short decodeShort() throws IOException;

    public char decodeChar() throws IOException;

    public int decodeInt() throws IOException;

    public long decodeLong() throws IOException;

    public float decodeFloat() throws IOException;

    public double decodeDouble() throws IOException;

    @NonNull
    public BigInteger decodeBigInteger() throws IOException;

    @NonNull
    public BigDecimal decodeBigDecimal() throws IOException;

    public boolean decodeNull() throws IOException;

    @Nullable
    public Object decodeArbitrary() throws IOException;

    public Decoder decodeBuffer() throws IOException;

    public void skipValue() throws IOException;

    public void finishStructure() throws IOException;

    @Override
    default public void close() throws IOException {
        this.finishStructure();
    }

    @NonNull
    public IOException createDeserializationException(@NonNull String var1, @Nullable Object var2);
}

