/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde;

import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.BeanContext;
import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.context.env.DefaultEnvironment;
import io.micronaut.context.env.Environment;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.serde.ObjectMapper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

final class ObjectMappers {
    private static volatile ObjectMapper defaultObjectMapper;
    private static volatile BeanContext beanContext;
    private static final Object MAPPER_LOCK;
    private static final Object CONTEXT_LOCK;

    private ObjectMappers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectMapper resolveDefault() {
        ObjectMapper objectMapper = defaultObjectMapper;
        if (objectMapper == null) {
            Object object = MAPPER_LOCK;
            synchronized (object) {
                objectMapper = defaultObjectMapper;
                if (objectMapper == null) {
                    defaultObjectMapper = objectMapper = (ObjectMapper)ObjectMappers.resolveBeanContext().getBean(ObjectMapper.class);
                }
            }
        }
        return objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BeanContext resolveBeanContext() {
        BeanContext context = beanContext;
        if (context == null) {
            Object object = CONTEXT_LOCK;
            synchronized (object) {
                context = beanContext;
                if (context == null) {
                    beanContext = context = new ObjectMapperContext().start();
                }
            }
        }
        return context;
    }

    static {
        MAPPER_LOCK = new Object();
        CONTEXT_LOCK = new Object();
    }

    private static class ObjectMapperContext
    extends DefaultApplicationContext {
        private ObjectMapperContext() {
            super(new String[0]);
        }

        protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
            return super.resolveBeanDefinitionReferences().stream().filter(ref -> ref.getBeanDefinitionName().startsWith("io.micronaut.serde") || ref.getBeanDefinitionName().startsWith("io.micronaut.aop") || ref.getBeanDefinitionName().startsWith("io.micronaut.runtime.context.env")).collect(Collectors.toList());
        }

        public Future<Void> publishEventAsync(Object event) {
            return CompletableFuture.completedFuture(null);
        }

        public void publishEvent(Object event) {
        }

        protected Environment createEnvironment(ApplicationContextConfiguration configuration) {
            return new DefaultEnvironment((ApplicationContextConfiguration)this.getContextConfiguration()){

                protected void readPropertySources(String name) {
                }
            };
        }
    }
}

