/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.config;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.bind.annotation.Bindable;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;

@ConfigurationProperties(value="micronaut.serde")
@BootstrapContextCompatible
public interface SerdeConfiguration {
    public static final String PREFIX = "micronaut.serde";

    public Optional<String> getDateFormat();

    @Bindable(defaultValue="STRING")
    public TimeShape getTimeWriteShape();

    @Bindable(defaultValue="SECONDS")
    public NumericTimeUnit getNumericTimeUnit();

    @Bindable(defaultValue="true")
    public boolean isWriteBinaryAsArray();

    public Optional<Locale> getLocale();

    public Optional<TimeZone> getTimeZone();

    @Bindable(defaultValue="io.micronaut")
    public List<String> getIncludedIntrospectionPackages();

    @Bindable(defaultValue="1024")
    public int getMaximumNestingDepth();

    public static enum NumericTimeUnit {
        LEGACY,
        SECONDS,
        MILLISECONDS,
        NANOSECONDS;

    }

    public static enum TimeShape {
        STRING,
        INTEGER,
        DECIMAL;

    }
}

