/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.util.BinaryCodecUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface Decoder
extends AutoCloseable {
    @NonNull
    public Decoder decodeArray(Argument<?> var1) throws IOException;

    @NonNull
    default public Decoder decodeArray() throws IOException {
        return this.decodeArray(Argument.OBJECT_ARGUMENT);
    }

    public boolean hasNextArrayValue() throws IOException;

    @NonNull
    public Decoder decodeObject(@NonNull Argument<?> var1) throws IOException;

    @NonNull
    default public Decoder decodeObject() throws IOException {
        return this.decodeObject(Argument.OBJECT_ARGUMENT);
    }

    @Nullable
    public String decodeKey() throws IOException;

    @NonNull
    public String decodeString() throws IOException;

    @Nullable
    default public String decodeStringNullable() throws IOException {
        return this.decodeNull() ? null : this.decodeString();
    }

    public boolean decodeBoolean() throws IOException;

    @Nullable
    default public Boolean decodeBooleanNullable() throws IOException {
        return this.decodeNull() ? null : Boolean.valueOf(this.decodeBoolean());
    }

    public byte decodeByte() throws IOException;

    @Nullable
    default public Byte decodeByteNullable() throws IOException {
        return this.decodeNull() ? null : Byte.valueOf(this.decodeByte());
    }

    public short decodeShort() throws IOException;

    @Nullable
    default public Short decodeShortNullable() throws IOException {
        return this.decodeNull() ? null : Short.valueOf(this.decodeShort());
    }

    public char decodeChar() throws IOException;

    @Nullable
    default public Character decodeCharNullable() throws IOException {
        return this.decodeNull() ? null : Character.valueOf(this.decodeChar());
    }

    public int decodeInt() throws IOException;

    @Nullable
    default public Integer decodeIntNullable() throws IOException {
        return this.decodeNull() ? null : Integer.valueOf(this.decodeInt());
    }

    public long decodeLong() throws IOException;

    @Nullable
    default public Long decodeLongNullable() throws IOException {
        return this.decodeNull() ? null : Long.valueOf(this.decodeLong());
    }

    public float decodeFloat() throws IOException;

    @Nullable
    default public Float decodeFloatNullable() throws IOException {
        return this.decodeNull() ? null : Float.valueOf(this.decodeFloat());
    }

    public double decodeDouble() throws IOException;

    @Nullable
    default public Double decodeDoubleNullable() throws IOException {
        return this.decodeNull() ? null : Double.valueOf(this.decodeDouble());
    }

    @NonNull
    public BigInteger decodeBigInteger() throws IOException;

    @Nullable
    default public BigInteger decodeBigIntegerNullable() throws IOException {
        return this.decodeNull() ? null : this.decodeBigInteger();
    }

    @NonNull
    public BigDecimal decodeBigDecimal() throws IOException;

    @Nullable
    default public BigDecimal decodeBigDecimalNullable() throws IOException {
        return this.decodeNull() ? null : this.decodeBigDecimal();
    }

    default public byte @NonNull [] decodeBinary() throws IOException {
        return BinaryCodecUtil.decodeFromArray(this);
    }

    default public byte @Nullable [] decodeBinaryNullable() throws IOException {
        return this.decodeNull() ? null : this.decodeBinary();
    }

    public boolean decodeNull() throws IOException;

    @Nullable
    public Object decodeArbitrary() throws IOException;

    @NonNull
    public JsonNode decodeNode() throws IOException;

    public Decoder decodeBuffer() throws IOException;

    public void skipValue() throws IOException;

    default public void finishStructure() throws IOException {
        this.finishStructure(false);
    }

    public void finishStructure(boolean var1) throws IOException;

    @Override
    default public void close() throws IOException {
        this.finishStructure();
    }

    @NonNull
    public IOException createDeserializationException(@NonNull String var1, @Nullable Object var2);
}

