/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.bson.custom;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.bson.BsonReaderDecoder;
import io.micronaut.serde.bson.BsonWriterEncoder;
import io.micronaut.serde.exceptions.SerdeException;
import java.io.IOException;

public abstract class AbstractBsonSerde<T>
implements Serde<T> {
    protected abstract T doDeserialize(BsonReaderDecoder var1, Deserializer.DecoderContext var2, Argument<? super T> var3) throws IOException;

    protected abstract void doSerialize(BsonWriterEncoder var1, Serializer.EncoderContext var2, T var3, Argument<? extends T> var4) throws IOException;

    public final T deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super T> type) throws IOException {
        return this.doDeserialize(this.asBson(decoder), decoderContext, type);
    }

    public final void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        this.doSerialize(this.asBson(encoder), context, value, type);
    }

    private BsonReaderDecoder asBson(Decoder decoder) throws SerdeException {
        if (decoder instanceof BsonReaderDecoder) {
            return (BsonReaderDecoder)decoder;
        }
        throw new SerdeException("Expected an instance of BsonParserDecoder got: " + decoder);
    }

    private BsonWriterEncoder asBson(Encoder encoder) throws SerdeException {
        if (encoder instanceof BsonWriterEncoder) {
            BsonWriterEncoder bsonWriterEncoder = (BsonWriterEncoder)encoder;
            return bsonWriterEncoder;
        }
        throw new SerdeException("Expected an instance of BsonWriterEncoder got: " + encoder);
    }
}

