/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.bson;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonStreamConfig;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectMapper;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.bson.BsonReaderDecoder;
import io.micronaut.serde.bson.BsonWriterEncoder;
import io.micronaut.serde.support.util.BufferingJsonNodeProcessor;
import io.micronaut.serde.support.util.JsonNodeDecoder;
import io.micronaut.serde.support.util.JsonNodeEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.bson.AbstractBsonWriter;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.reactivestreams.Processor;

@Internal
public abstract class AbstractBsonMapper
implements ObjectMapper {
    protected final SerdeRegistry registry;
    protected final Class<?> view;
    protected Serializer.EncoderContext encoderContext;
    protected Deserializer.DecoderContext decoderContext;

    public AbstractBsonMapper(SerdeRegistry registry) {
        this(registry, null);
    }

    protected AbstractBsonMapper(SerdeRegistry registry, Class<?> view) {
        this.registry = registry;
        this.view = view;
        this.encoderContext = registry.newEncoderContext(view);
        this.decoderContext = registry.newDecoderContext(view);
    }

    protected abstract BsonReader createBsonReader(ByteBuffer var1);

    protected abstract AbstractBsonWriter createBsonWriter(OutputStream var1) throws IOException;

    public <T> JsonNode writeValueToTree(Argument<T> type, T value) throws IOException {
        JsonNodeEncoder encoder = JsonNodeEncoder.create();
        this.serialize((Encoder)encoder, value);
        return encoder.getCompletedValue();
    }

    public <T> void writeValue(OutputStream outputStream, Argument<T> type, T object) throws IOException {
        try (AbstractBsonWriter bsonWriter = this.createBsonWriter(outputStream);){
            if (object == null) {
                bsonWriter.writeNull();
            } else {
                BsonWriterEncoder encoder = new BsonWriterEncoder((BsonWriter)bsonWriter);
                this.serialize(encoder, object, type);
            }
            bsonWriter.flush();
        }
    }

    public <T> byte[] writeValueAsBytes(Argument<T> type, T object) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.writeValue(output, type, object);
        return output.toByteArray();
    }

    public <T> T readValueFromTree(JsonNode tree, Argument<T> type) throws IOException {
        Deserializer deserializer = this.decoderContext.findDeserializer(type).createSpecific(this.decoderContext, type);
        return (T)deserializer.deserialize((Decoder)JsonNodeDecoder.create((JsonNode)tree), this.decoderContext, type);
    }

    public <T> T readValue(InputStream inputStream, Argument<T> type) throws IOException {
        return this.readValue(this.toByteBuffer(inputStream), type);
    }

    public <T> T readValue(byte[] byteArray, Argument<T> type) throws IOException {
        return this.readValue(ByteBuffer.wrap(byteArray), type);
    }

    private <T> T readValue(ByteBuffer byteBuffer, Argument<T> type) throws IOException {
        try (BsonReader bsonReader = this.createBsonReader(byteBuffer);){
            T t = this.readValue(bsonReader, type);
            return t;
        }
    }

    private <T> T readValue(BsonReader bsonReader, Argument<T> type) throws IOException {
        return (T)this.decoderContext.findDeserializer(type).createSpecific(this.decoderContext, type).deserialize((Decoder)new BsonReaderDecoder(bsonReader), this.decoderContext, type);
    }

    public Processor<byte[], JsonNode> createReactiveParser(Consumer<Processor<byte[], JsonNode>> onSubscribe, boolean streamArray) {
        return new BufferingJsonNodeProcessor(onSubscribe, streamArray){

            @NonNull
            protected JsonNode parseOne(@NonNull InputStream is) throws IOException {
                try (BsonReader bsonReader = AbstractBsonMapper.this.createBsonReader(AbstractBsonMapper.this.toByteBuffer(is));){
                    BsonReaderDecoder decoder = new BsonReaderDecoder(bsonReader);
                    Object o = decoder.decodeArbitrary();
                    JsonNode jsonNode = AbstractBsonMapper.this.writeValueToTree(o);
                    return jsonNode;
                }
            }

            protected JsonNode parseOne(byte[] remaining) throws IOException {
                try (BsonReader bsonReader = AbstractBsonMapper.this.createBsonReader(ByteBuffer.wrap(remaining));){
                    BsonReaderDecoder decoder = new BsonReaderDecoder(bsonReader);
                    Object o = decoder.decodeArbitrary();
                    JsonNode jsonNode = AbstractBsonMapper.this.writeValueToTree(o);
                    return jsonNode;
                }
            }
        };
    }

    public JsonNode writeValueToTree(Object value) throws IOException {
        JsonNodeEncoder encoder = JsonNodeEncoder.create();
        this.serialize((Encoder)encoder, value);
        return encoder.getCompletedValue();
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException {
        try (AbstractBsonWriter bsonWriter = this.createBsonWriter(outputStream);){
            if (object == null) {
                bsonWriter.writeNull();
            } else {
                BsonWriterEncoder encoder = new BsonWriterEncoder((BsonWriter)bsonWriter);
                this.serialize(encoder, object);
            }
            bsonWriter.flush();
        }
    }

    private void serialize(Encoder encoder, Object object) throws IOException {
        this.serialize(encoder, object, Argument.of(object.getClass()));
    }

    private void serialize(Encoder encoder, Object object, Argument type) throws IOException {
        Serializer serializer = this.encoderContext.findSerializer(type).createSpecific(this.encoderContext, type);
        serializer.serialize(encoder, this.encoderContext, type, object);
    }

    public byte[] writeValueAsBytes(Object object) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.writeValue(output, object);
        return output.toByteArray();
    }

    public JsonStreamConfig getStreamConfig() {
        return JsonStreamConfig.DEFAULT;
    }

    private ByteBuffer toByteBuffer(InputStream inputStream) throws IOException {
        int nbByteRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] byteBuffer = new byte[512];
        while ((nbByteRead = inputStream.read(byteBuffer)) != -1) {
            baos.write(byteBuffer, 0, nbByteRead);
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }
}

