/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.bson;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Order;
import io.micronaut.json.JsonMapper;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.bson.AbstractBsonMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.bson.AbstractBsonWriter;
import org.bson.BsonReader;
import org.bson.json.JsonMode;
import org.bson.json.JsonReader;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

@Singleton
@BootstrapContextCompatible
@Order(value=100)
public final class BsonJsonMapper
extends AbstractBsonMapper {
    @Inject
    public BsonJsonMapper(SerdeRegistry registry) {
        super(registry);
    }

    public BsonJsonMapper(SerdeRegistry registry, Class<?> view) {
        super(registry, view);
    }

    public JsonMapper cloneWithViewClass(Class<?> viewClass) {
        return new BsonJsonMapper(this.registry, viewClass);
    }

    @Override
    protected BsonReader createBsonReader(ByteBuffer byteBuffer) {
        return new JsonReader(new String(byteBuffer.array(), StandardCharsets.UTF_8));
    }

    @Override
    protected AbstractBsonWriter createBsonWriter(OutputStream outputStream) {
        return new JsonWriter((Writer)new OutputStreamWriter(outputStream), JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build());
    }
}

