/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.bson;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.SerdeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.bson.BsonWriter;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

@Internal
public final class BsonWriterEncoder
extends LimitingStream
implements Encoder {
    private final BsonWriter bsonWriter;
    private final boolean isArray;
    private final BsonWriterEncoder parent;
    private String currentKey = null;
    private int currentIndex = 0;

    public BsonWriterEncoder(BsonWriter bsonWriter, LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
        this.bsonWriter = bsonWriter;
        this.isArray = false;
        this.parent = null;
    }

    private BsonWriterEncoder(BsonWriterEncoder parent, LimitingStream.RemainingLimits remainingLimits, boolean isArray) {
        super(remainingLimits);
        this.bsonWriter = parent.bsonWriter;
        this.isArray = isArray;
        this.parent = parent;
    }

    private void postEncodeValue() {
        ++this.currentIndex;
    }

    public Encoder encodeArray(Argument<?> type) throws SerdeException {
        this.bsonWriter.writeStartArray();
        return new BsonWriterEncoder(this, this.childLimits(), true);
    }

    public Encoder encodeObject(Argument<?> type) throws SerdeException {
        this.bsonWriter.writeStartDocument();
        return new BsonWriterEncoder(this, this.childLimits(), false);
    }

    public void finishStructure() {
        if (this.parent == null) {
            throw new IllegalStateException("Not in a structure");
        }
        if (this.isArray) {
            this.bsonWriter.writeEndArray();
        } else {
            this.bsonWriter.writeEndDocument();
        }
        this.parent.postEncodeValue();
    }

    public void encodeKey(String key) {
        this.currentKey = key;
        this.bsonWriter.writeName(key);
    }

    public void encodeString(String value) {
        this.bsonWriter.writeString(value);
        this.postEncodeValue();
    }

    public void encodeBoolean(boolean value) {
        this.bsonWriter.writeBoolean(value);
        this.postEncodeValue();
    }

    public void encodeByte(byte value) {
        this.bsonWriter.writeInt32((int)value);
        this.postEncodeValue();
    }

    public void encodeShort(short value) {
        this.bsonWriter.writeInt32((int)value);
        this.postEncodeValue();
    }

    public void encodeChar(char value) {
        this.bsonWriter.writeInt32((int)value);
        this.postEncodeValue();
    }

    public void encodeInt(int value) {
        this.bsonWriter.writeInt32(value);
        this.postEncodeValue();
    }

    public void encodeLong(long value) {
        this.bsonWriter.writeInt64(value);
        this.postEncodeValue();
    }

    public void encodeFloat(float value) {
        this.bsonWriter.writeDouble((double)value);
        this.postEncodeValue();
    }

    public void encodeDouble(double value) {
        this.bsonWriter.writeDouble(value);
        this.postEncodeValue();
    }

    public void encodeBigInteger(BigInteger value) {
        this.encodeBigDecimal(new BigDecimal(value));
        this.postEncodeValue();
    }

    public void encodeBigDecimal(BigDecimal value) {
        this.bsonWriter.writeDecimal128(new Decimal128(value));
        this.postEncodeValue();
    }

    public void encodeNull() {
        this.bsonWriter.writeNull();
        this.postEncodeValue();
    }

    @NonNull
    public String currentPath() {
        StringBuilder builder = new StringBuilder();
        BsonWriterEncoder enc = this;
        while (enc != null) {
            if (enc != this) {
                builder.insert(0, "->");
            }
            if (enc.currentKey == null) {
                if (enc.parent != null) {
                    builder.insert(0, enc.currentIndex);
                }
            } else {
                builder.insert(0, enc.currentKey);
            }
            enc = enc.parent;
        }
        return builder.toString();
    }

    public void encodeDecimal128(Decimal128 value) {
        this.bsonWriter.writeDecimal128(value);
        this.postEncodeValue();
    }

    public void encodeObjectId(ObjectId value) {
        this.bsonWriter.writeObjectId(value);
        this.postEncodeValue();
    }

    public BsonWriter getBsonWriter() {
        return this.bsonWriter;
    }
}

