/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.bson;

import io.micronaut.core.annotation.Order;
import io.micronaut.json.JsonMapper;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.bson.AbstractBsonMapper;
import io.micronaut.serde.config.SerdeConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.bson.AbstractBsonWriter;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonReader;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;

@Singleton
@Order(value=200)
public final class BsonBinaryMapper
extends AbstractBsonMapper {
    @Inject
    public BsonBinaryMapper(SerdeRegistry registry, SerdeConfiguration serdeConfiguration) {
        super(registry, serdeConfiguration);
    }

    public BsonBinaryMapper(SerdeRegistry registry, SerdeConfiguration serdeConfiguration, Class<?> view) {
        super(registry, serdeConfiguration, view);
    }

    public JsonMapper cloneWithViewClass(Class<?> viewClass) {
        return new BsonBinaryMapper(this.registry, this.serdeConfiguration, viewClass);
    }

    @Override
    protected BsonReader createBsonReader(ByteBuffer byteBuffer) {
        return new BsonBinaryReader(byteBuffer);
    }

    @Override
    protected AbstractBsonWriter createBsonWriter(final OutputStream os) {
        Objects.requireNonNull(os, "Output stream cannot be null");
        return new BsonBinaryWriter((BsonOutput)new BasicOutputBuffer()){

            public void flush() {
                try {
                    ((BasicOutputBuffer)this.getBsonOutput()).pipe(os);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

