/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.bson.custom;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.bson.BsonReaderDecoder;
import io.micronaut.serde.bson.BsonWriterEncoder;
import io.micronaut.serde.bson.custom.AbstractBsonSerde;
import io.micronaut.serde.exceptions.SerdeException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.UUID;
import org.bson.BsonBinary;
import org.bson.BsonDbPointer;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.pojo.annotations.BsonRepresentation;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

@Singleton
public final class BsonRepresentationSerde
extends AbstractBsonSerde<Object> {
    @Override
    protected Object doDeserialize(BsonReaderDecoder decoder, Deserializer.DecoderContext context, Argument<? super Object> type) throws IOException {
        BsonType bsonType = this.getBsonType(type);
        return decoder.decodeCustom((bsonReader, ctx) -> {
            switch (bsonType) {
                case DOUBLE: {
                    return this.convert(context, type, bsonReader.readDouble());
                }
                case STRING: {
                    if (type.getType().equals(ObjectId.class)) {
                        return new ObjectId(bsonReader.readString());
                    }
                    return this.convert(context, type, bsonReader.readString());
                }
                case JAVASCRIPT: {
                    return this.convert(context, type, bsonReader.readJavaScript());
                }
                case SYMBOL: {
                    return this.convert(context, type, bsonReader.readSymbol());
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.convert(context, type, bsonReader.readJavaScriptWithScope());
                }
                case BINARY: {
                    if (type.getType().equals(byte[].class)) {
                        return bsonReader.readBinaryData().getData();
                    }
                    if (type.getType().equals(UUID.class)) {
                        return bsonReader.readBinaryData().asUuid();
                    }
                    return this.convert(context, type, bsonReader.readBinaryData());
                }
                case OBJECT_ID: {
                    return this.convert(context, type, bsonReader.readObjectId());
                }
                case BOOLEAN: {
                    return this.convert(context, type, bsonReader.readBoolean());
                }
                case DATE_TIME: {
                    return this.convert(context, type, bsonReader.readDateTime());
                }
                case REGULAR_EXPRESSION: {
                    return this.convert(context, type, bsonReader.readRegularExpression());
                }
                case DB_POINTER: {
                    return this.convert(context, type, bsonReader.readDBPointer());
                }
                case INT32: {
                    return this.convert(context, type, bsonReader.readInt32());
                }
                case TIMESTAMP: {
                    return this.convert(context, type, bsonReader.readTimestamp());
                }
                case INT64: {
                    return this.convert(context, type, bsonReader.readInt64());
                }
                case DECIMAL128: {
                    return this.convert(context, type, bsonReader.readDecimal128());
                }
            }
            throw new UncheckedIOException((IOException)new SerdeException("Unsupported BsonType: " + String.valueOf(bsonType)));
        }, null);
    }

    private Object convert(Deserializer.DecoderContext context, Argument<? super Object> type, Object value) {
        if (type.isInstance(value)) {
            return value;
        }
        return context.getConversionService().convertRequired(value, type);
    }

    @Override
    protected void doSerialize(BsonWriterEncoder encoder, Serializer.EncoderContext context, Object value, Argument<?> type) throws IOException {
        if (value == null) {
            encoder.encodeNull();
        } else {
            BsonWriter bsonWriter = encoder.getBsonWriter();
            BsonType bsonType = this.getBsonType(type);
            switch (bsonType) {
                case DOUBLE: {
                    bsonWriter.writeDouble(this.convert(context, value, Double.class).doubleValue());
                    break;
                }
                case STRING: {
                    if (value instanceof ObjectId) {
                        bsonWriter.writeString(((ObjectId)value).toHexString());
                        break;
                    }
                    bsonWriter.writeString(this.convert(context, value, String.class));
                    break;
                }
                case BINARY: {
                    if (value instanceof byte[]) {
                        bsonWriter.writeBinaryData(new BsonBinary((byte[])value));
                        break;
                    }
                    if (value instanceof UUID) {
                        bsonWriter.writeBinaryData(new BsonBinary((UUID)value));
                        break;
                    }
                    bsonWriter.writeBinaryData(this.convert(context, value, BsonBinary.class));
                    break;
                }
                case OBJECT_ID: {
                    if (value instanceof String) {
                        bsonWriter.writeObjectId(new ObjectId((String)value));
                        break;
                    }
                    bsonWriter.writeObjectId(this.convert(context, value, ObjectId.class));
                    break;
                }
                case BOOLEAN: {
                    bsonWriter.writeBoolean(this.convert(context, value, Boolean.class).booleanValue());
                    break;
                }
                case DATE_TIME: {
                    if (value instanceof Long) {
                        bsonWriter.writeDateTime(((Long)value).longValue());
                        break;
                    }
                    bsonWriter.writeDateTime(this.convert(context, value, Instant.class).getEpochSecond());
                    break;
                }
                case REGULAR_EXPRESSION: {
                    bsonWriter.writeRegularExpression(this.convert(context, value, BsonRegularExpression.class));
                    break;
                }
                case DB_POINTER: {
                    bsonWriter.writeDBPointer(this.convert(context, value, BsonDbPointer.class));
                    break;
                }
                case JAVASCRIPT: {
                    bsonWriter.writeJavaScript(this.convert(context, value, String.class));
                    break;
                }
                case SYMBOL: {
                    bsonWriter.writeSymbol(this.convert(context, value, String.class));
                    break;
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    bsonWriter.writeJavaScriptWithScope(this.convert(context, value, String.class));
                    break;
                }
                case INT32: {
                    bsonWriter.writeInt32(this.convert(context, value, Integer.class).intValue());
                    break;
                }
                case TIMESTAMP: {
                    bsonWriter.writeTimestamp(this.convert(context, value, BsonTimestamp.class));
                    break;
                }
                case INT64: {
                    bsonWriter.writeInt64(this.convert(context, value, Long.class).longValue());
                    break;
                }
                case DECIMAL128: {
                    if (value instanceof BigDecimal) {
                        bsonWriter.writeDecimal128(new Decimal128((BigDecimal)value));
                        break;
                    }
                    bsonWriter.writeDecimal128(this.convert(context, value, Decimal128.class));
                    break;
                }
                default: {
                    throw new SerdeException("Unsupported BsonType: " + String.valueOf(bsonType));
                }
            }
        }
    }

    private <T> T convert(Serializer.EncoderContext context, Object value, Class<T> clazz) {
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        return (T)context.getConversionService().convertRequired(value, clazz);
    }

    private BsonType getBsonType(Argument<?> type) throws SerdeException {
        return (BsonType)type.getAnnotationMetadata().enumValue(BsonRepresentation.class, BsonType.class).orElseThrow(() -> new SerdeException("BsonType is expected for @BsonRepresentation!"));
    }
}

