/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.bson;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.AbstractDecoderPerStructureStreamDecoder;
import io.micronaut.serde.support.AbstractStreamDecoder;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.DecoderContext;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

@Internal
public final class BsonReaderDecoder
extends AbstractDecoderPerStructureStreamDecoder {
    private final BsonReader bsonReader;
    private final Deque<Context> contextStack;
    private BsonType currentBsonType;
    private AbstractStreamDecoder.TokenType currentToken;

    public BsonReaderDecoder(BsonReader bsonReader, @NonNull LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
        this.bsonReader = bsonReader;
        this.contextStack = new ArrayDeque<Context>();
        BsonType currentBsonType = bsonReader.getCurrentBsonType();
        if (currentBsonType == null) {
            this.contextStack.add(Context.TOP);
            this.nextToken();
        } else if (currentBsonType == BsonType.DOCUMENT) {
            this.contextStack.push(Context.TOP);
            this.currentToken = AbstractStreamDecoder.TokenType.START_OBJECT;
            this.currentBsonType = BsonType.DOCUMENT;
        }
    }

    private BsonReaderDecoder(BsonReaderDecoder parent, @NonNull LimitingStream.RemainingLimits remainingLimits) {
        super((AbstractDecoderPerStructureStreamDecoder)parent, remainingLimits);
        this.bsonReader = parent.bsonReader;
        this.contextStack = parent.contextStack;
        this.currentBsonType = parent.currentBsonType;
        this.currentToken = parent.currentToken;
    }

    protected void backFromChild(AbstractStreamDecoder child) throws IOException {
        this.currentBsonType = ((BsonReaderDecoder)child).currentBsonType;
        this.currentToken = ((BsonReaderDecoder)child).currentToken;
        super.backFromChild(child);
    }

    protected void nextToken() {
        Context ctx;
        if (this.currentToken != null) {
            switch (this.currentToken) {
                case START_ARRAY: {
                    this.contextStack.push(Context.ARRAY);
                    this.bsonReader.readStartArray();
                    break;
                }
                case START_OBJECT: {
                    this.contextStack.push(Context.DOCUMENT);
                    this.bsonReader.readStartDocument();
                    break;
                }
                case END_ARRAY: {
                    this.contextStack.pop();
                    this.bsonReader.readEndArray();
                    break;
                }
                case END_OBJECT: {
                    this.contextStack.pop();
                    this.bsonReader.readEndDocument();
                    break;
                }
                case NULL: {
                    this.bsonReader.readNull();
                    break;
                }
            }
        }
        if ((ctx = this.contextStack.peek()) == Context.DOCUMENT) {
            if (this.currentToken == AbstractStreamDecoder.TokenType.KEY) {
                this.currentToken = BsonReaderDecoder.toToken(this.currentBsonType, ctx);
            } else {
                this.currentBsonType = this.bsonReader.readBsonType();
                this.currentToken = this.currentBsonType == BsonType.END_OF_DOCUMENT ? AbstractStreamDecoder.TokenType.END_OBJECT : AbstractStreamDecoder.TokenType.KEY;
            }
        } else if (ctx != Context.TOP || this.currentBsonType != BsonType.END_OF_DOCUMENT) {
            this.currentBsonType = this.bsonReader.readBsonType();
            this.currentToken = BsonReaderDecoder.toToken(this.currentBsonType, ctx);
        }
    }

    private static AbstractStreamDecoder.TokenType toToken(BsonType bsonType, Context ctx) {
        switch (bsonType) {
            case ARRAY: {
                return AbstractStreamDecoder.TokenType.START_ARRAY;
            }
            case DOCUMENT: {
                return AbstractStreamDecoder.TokenType.START_OBJECT;
            }
            case END_OF_DOCUMENT: {
                if (ctx == Context.ARRAY) {
                    return AbstractStreamDecoder.TokenType.END_ARRAY;
                }
                if (ctx == Context.DOCUMENT) {
                    return AbstractStreamDecoder.TokenType.END_OBJECT;
                }
                return null;
            }
            case DOUBLE: 
            case INT32: 
            case INT64: 
            case DECIMAL128: {
                return AbstractStreamDecoder.TokenType.NUMBER;
            }
            case STRING: {
                return AbstractStreamDecoder.TokenType.STRING;
            }
            case BOOLEAN: {
                return AbstractStreamDecoder.TokenType.BOOLEAN;
            }
            case NULL: {
                return AbstractStreamDecoder.TokenType.NULL;
            }
        }
        return AbstractStreamDecoder.TokenType.OTHER;
    }

    protected String getCurrentKey() {
        return this.bsonReader.readName();
    }

    protected String coerceScalarToString(AbstractStreamDecoder.TokenType currentToken) throws IOException {
        return switch (this.currentBsonType) {
            case BsonType.DOUBLE -> String.valueOf(this.bsonReader.readDouble());
            case BsonType.STRING -> this.bsonReader.readString();
            case BsonType.OBJECT_ID -> this.bsonReader.readObjectId().toHexString();
            case BsonType.BOOLEAN -> String.valueOf(this.bsonReader.readBoolean());
            case BsonType.DATE_TIME -> String.valueOf(this.bsonReader.readDateTime());
            case BsonType.REGULAR_EXPRESSION -> this.bsonReader.readRegularExpression().toString();
            case BsonType.JAVASCRIPT -> this.bsonReader.readJavaScript();
            case BsonType.SYMBOL -> this.bsonReader.readSymbol();
            case BsonType.JAVASCRIPT_WITH_SCOPE -> this.bsonReader.readJavaScriptWithScope();
            case BsonType.INT32 -> String.valueOf(this.bsonReader.readInt32());
            case BsonType.TIMESTAMP -> this.bsonReader.readTimestamp().toString();
            case BsonType.INT64 -> String.valueOf(this.bsonReader.readInt64());
            case BsonType.DECIMAL128 -> this.bsonReader.readDecimal128().toString();
            case BsonType.BINARY -> new String(this.bsonReader.readBinaryData().getData(), StandardCharsets.UTF_8);
            case BsonType.DB_POINTER -> this.bsonReader.readDBPointer().toString();
            default -> throw new SerdeException("Can't decode " + String.valueOf(this.currentBsonType) + " as string");
        };
    }

    protected AbstractStreamDecoder createChildDecoder() throws SerdeException {
        return new BsonReaderDecoder(this, this.childLimits());
    }

    protected String getString() {
        return this.bsonReader.readString();
    }

    protected boolean getBoolean() {
        return this.bsonReader.readBoolean();
    }

    protected long getLong() {
        return switch (this.currentBsonType) {
            case BsonType.INT32 -> this.bsonReader.readInt32();
            case BsonType.INT64 -> this.bsonReader.readInt64();
            case BsonType.DOUBLE -> (long)this.bsonReader.readDouble();
            case BsonType.DECIMAL128 -> this.bsonReader.readDecimal128().longValue();
            default -> throw this.getNotInNumberState();
        };
    }

    private IllegalStateException getNotInNumberState() {
        return new IllegalStateException("Not in number state");
    }

    protected double getDouble() {
        return switch (this.currentBsonType) {
            case BsonType.INT32 -> this.bsonReader.readInt32();
            case BsonType.INT64 -> this.bsonReader.readInt64();
            case BsonType.DOUBLE -> this.bsonReader.readDouble();
            case BsonType.DECIMAL128 -> this.bsonReader.readDecimal128().doubleValue();
            default -> throw this.getNotInNumberState();
        };
    }

    protected BigInteger getBigInteger() {
        return switch (this.currentBsonType) {
            case BsonType.INT32 -> BigInteger.valueOf(this.bsonReader.readInt32());
            case BsonType.INT64 -> BigInteger.valueOf(this.bsonReader.readInt64());
            case BsonType.DOUBLE -> BigDecimal.valueOf(this.bsonReader.readDouble()).toBigInteger();
            case BsonType.DECIMAL128 -> this.bsonReader.readDecimal128().bigDecimalValue().toBigInteger();
            default -> throw this.getNotInNumberState();
        };
    }

    protected BigDecimal getBigDecimal() {
        return switch (this.currentBsonType) {
            case BsonType.INT32 -> BigDecimal.valueOf(this.bsonReader.readInt32());
            case BsonType.INT64 -> BigDecimal.valueOf(this.bsonReader.readInt64());
            case BsonType.DOUBLE -> BigDecimal.valueOf(this.bsonReader.readDouble());
            case BsonType.DECIMAL128 -> this.bsonReader.readDecimal128().bigDecimalValue();
            default -> throw this.getNotInNumberState();
        };
    }

    protected Number getBestNumber() {
        return switch (this.currentBsonType) {
            case BsonType.INT32 -> Integer.valueOf(this.bsonReader.readInt32());
            case BsonType.INT64 -> Long.valueOf(this.bsonReader.readInt64());
            case BsonType.DOUBLE -> Double.valueOf(this.bsonReader.readDouble());
            case BsonType.DECIMAL128 -> this.bsonReader.readDecimal128();
            default -> throw this.getNotInNumberState();
        };
    }

    protected BigDecimal getBigDecimalFromNumber(Number number) {
        if (number instanceof Decimal128) {
            Decimal128 decimal128 = (Decimal128)number;
            return decimal128.bigDecimalValue();
        }
        return super.getBigDecimalFromNumber(number);
    }

    public byte @NonNull [] decodeBinary() throws IOException {
        if (this.currentBsonType == BsonType.BINARY) {
            return (byte[])this.decodeCustom(parser -> ((BsonReaderDecoder)parser).bsonReader.readBinaryData().getData());
        }
        return super.decodeBinary();
    }

    protected void skipChildren() {
        this.bsonReader.skipValue();
        this.currentToken = null;
    }

    protected AbstractStreamDecoder.TokenType currentToken() {
        return this.currentToken;
    }

    public IOException createDeserializationException(String message, Object invalidValue) {
        return new SerdeException(message + " \n at ");
    }

    private Decimal128 getDecimal128() {
        return switch (this.currentBsonType) {
            case BsonType.INT32 -> new Decimal128((long)this.bsonReader.readInt32());
            case BsonType.INT64 -> new Decimal128(this.bsonReader.readInt64());
            case BsonType.DOUBLE -> new Decimal128(BigDecimal.valueOf(this.bsonReader.readDouble()));
            case BsonType.DECIMAL128 -> this.bsonReader.readDecimal128();
            default -> throw this.getNotInNumberState();
        };
    }

    public Decimal128 decodeDecimal128() throws IOException {
        return (Decimal128)this.decodeNumber(this.currentToken(), decoder -> ((BsonReaderDecoder)decoder).getDecimal128(), Decimal128::parse, Decimal128.POSITIVE_ZERO, new Decimal128(1L));
    }

    public ObjectId decodeObjectId() throws IOException {
        if (this.currentBsonType != BsonType.OBJECT_ID) {
            throw this.createDeserializationException("Cannot decode ObjectId from: " + String.valueOf(this.currentBsonType), this.decodeArbitrary());
        }
        return (ObjectId)this.decodeCustom(parser -> ((BsonReaderDecoder)parser).bsonReader.readObjectId());
    }

    public <T> T decodeCustom(org.bson.codecs.Decoder<T> decoder, DecoderContext context) throws IOException {
        this.currentToken = null;
        this.currentBsonType = null;
        Object result = this.decodeCustom(p -> decoder.decode(this.bsonReader, context), false);
        Context ctx = this.contextStack.peek();
        if (ctx == Context.TOP) {
            return (T)result;
        }
        this.nextToken();
        return (T)result;
    }

    private byte[] copyValueToDocument() {
        BasicOutputBuffer buffer = new BasicOutputBuffer();
        try (BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)buffer);){
            writer.writeStartDocument();
            writer.writeName("");
            BsonReaderDecoder.transfer(this.bsonReader, (BsonWriter)writer, this.currentBsonType);
            writer.writeEndDocument();
        }
        this.currentToken = null;
        this.currentBsonType = null;
        return buffer.getInternalBuffer();
    }

    private Decoder decoderFromBytes(byte[] documentBytes) throws IOException {
        BsonReaderDecoder topDecoder = new BsonReaderDecoder((BsonReader)new BsonBinaryReader(ByteBuffer.wrap(documentBytes)), this.ourLimits());
        Decoder decoder = topDecoder.decodeObject();
        decoder.decodeKey();
        return decoder;
    }

    public Decoder decodeBuffer() throws IOException {
        byte[] documentBytes = (byte[])this.decodeCustom(p -> ((BsonReaderDecoder)p).copyValueToDocument());
        return this.decoderFromBytes(documentBytes);
    }

    private static void transfer(BsonReader src, BsonWriter dest, BsonType type) {
        switch (type) {
            case DOUBLE: {
                dest.writeDouble(src.readDouble());
                break;
            }
            case STRING: {
                dest.writeString(src.readString());
                break;
            }
            case DOCUMENT: {
                String name;
                src.readStartDocument();
                dest.writeStartDocument();
                while (src.readBsonType() != BsonType.END_OF_DOCUMENT && (name = src.readName()) != null) {
                    dest.writeName(name);
                    BsonReaderDecoder.transfer(src, dest, src.getCurrentBsonType());
                }
                src.readEndDocument();
                dest.writeEndDocument();
                break;
            }
            case ARRAY: {
                BsonType elementType;
                src.readStartArray();
                dest.writeStartArray();
                while ((elementType = src.readBsonType()) != BsonType.END_OF_DOCUMENT) {
                    BsonReaderDecoder.transfer(src, dest, elementType);
                }
                src.readEndArray();
                dest.writeEndArray();
                break;
            }
            case BINARY: {
                dest.writeBinaryData(src.readBinaryData());
                break;
            }
            case UNDEFINED: {
                src.readUndefined();
                dest.writeUndefined();
                break;
            }
            case OBJECT_ID: {
                dest.writeObjectId(src.readObjectId());
                break;
            }
            case BOOLEAN: {
                dest.writeBoolean(src.readBoolean());
                break;
            }
            case DATE_TIME: {
                dest.writeDateTime(src.readDateTime());
                break;
            }
            case NULL: {
                src.readNull();
                dest.writeNull();
                break;
            }
            case REGULAR_EXPRESSION: {
                dest.writeRegularExpression(src.readRegularExpression());
                break;
            }
            case DB_POINTER: {
                dest.writeDBPointer(src.readDBPointer());
                break;
            }
            case JAVASCRIPT: {
                dest.writeJavaScript(src.readJavaScript());
                break;
            }
            case SYMBOL: {
                dest.writeSymbol(src.readSymbol());
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                dest.writeJavaScriptWithScope(src.readJavaScriptWithScope());
                break;
            }
            case INT32: {
                dest.writeInt32(src.readInt32());
                break;
            }
            case TIMESTAMP: {
                dest.writeTimestamp(src.readTimestamp());
                break;
            }
            case INT64: {
                dest.writeInt64(src.readInt64());
                break;
            }
            case DECIMAL128: {
                dest.writeDecimal128(src.readDecimal128());
                break;
            }
            case MIN_KEY: {
                src.readMinKey();
                dest.writeMinKey();
                break;
            }
            case MAX_KEY: {
                src.readMaxKey();
                dest.writeMaxKey();
                break;
            }
            default: {
                throw new IllegalStateException("Can't transfer bson token: " + String.valueOf(type));
            }
        }
    }

    private static enum Context {
        ARRAY,
        DOCUMENT,
        TOP;

    }
}

